/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NewsJcrNodePermissionsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)NewsJcrNodePermissionsUpgradePlugin.class.getName());
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService repositoryService_;
    private static final String NEWS_NODES_FOLDER = "News";
    private static final String NEWS_WORKSPACE = "collaboration";

    public NewsJcrNodePermissionsUpgradePlugin(SettingService settingService, InitParams initParams, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService) {
        super(settingService, initParams);
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(NEWS_WORKSPACE, this.repositoryService_.getCurrentRepository());
            String spacesNodePath = this.nodeHierarchyCreator_.getJcrPath("groupsPath") + "/spaces";
            Node spacesRootNode = (Node)session.getItem(spacesNodePath);
            NodeIterator iter = spacesRootNode.getNodes();
            while (iter.hasNext()) {
                Node spaceNode = iter.nextNode();
                if (!spaceNode.hasNode(NEWS_NODES_FOLDER)) continue;
                Node spaceNewsRootNode = spaceNode.getNode(NEWS_NODES_FOLDER);
                ((ExtendedNode)spaceNewsRootNode).removePermission("*:/platform/administrators");
                spaceNewsRootNode.save();
            }
        }
    }
}

