/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade;

import io.meeds.content.news.model.News;
import io.meeds.content.news.model.NewsPageObject;
import io.meeds.content.news.service.NewsService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.collections4.ListUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.upgrade.ContentDraftArticlesUpgrade$AjcClosure1;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;

public class ContentDraftArticlesUpgrade
extends UpgradeProductPlugin {
    private static final Log LOG;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private NoteService noteService;
    private NewsService newsService;
    private SpaceService spaceService;
    private SettingService settingService;
    private MetadataService metadataService;
    private EntityManagerService entityManagerService;
    private int migratedDraftArticlesCount = 0;
    public static final MetadataType NEWS_METADATA_TYPE;
    public static final String NEWS_METADATA_NAME = "news";
    private static final String PLUGIN_NAME = "ContentDraftArticlesUpgrade";
    private static final String PLUGIN_EXECUTED_KEY = "contentDraftArticlesUpgradeExecuted";
    private static final String CONTENT_INCONSISTENT_DRAFT_ARTICLES_UPGRADE = "content.inconsistent.draft.articles.upgrade";
    private String contentInconsistentDraftArticlesUpgrade;
    private boolean upgradeFailed = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ContentDraftArticlesUpgrade(InitParams initParams, ActivityManager activityManager, IdentityManager identityManager, NoteService noteService, NewsService newsService, SpaceService spaceService, SettingService settingService, MetadataService metadataService, EntityManagerService entityManagerService) {
        super(initParams);
        if (initParams.containsKey((Object)CONTENT_INCONSISTENT_DRAFT_ARTICLES_UPGRADE)) {
            this.contentInconsistentDraftArticlesUpgrade = initParams.getValueParam(CONTENT_INCONSISTENT_DRAFT_ARTICLES_UPGRADE).getValue();
        }
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.noteService = noteService;
        this.newsService = newsService;
        this.spaceService = spaceService;
        this.settingService = settingService;
        this.metadataService = metadataService;
        this.entityManagerService = entityManagerService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start upgrade of draft articles");
        int notMigratedDraftArticlesCount = 0;
        int ignoredDraftArticlesCount = 0;
        int processedDraftArticlesCount = 0;
        long totalDraftArticlesCount = 0L;
        try {
            List<String> draftArticles = Arrays.asList(this.contentInconsistentDraftArticlesUpgrade.split(";"));
            totalDraftArticlesCount = draftArticles.size();
            LOG.info("Total number of draft articles to be migrated: {}", new Object[]{totalDraftArticlesCount});
            for (List draftArticlesChunk : ListUtils.partition(draftArticles, (int)10)) {
                Map<String, Integer> draftArticlesCountByTransaction = this.manageDraftArticles(draftArticlesChunk);
                int processedDraftArticlesCountByTransaction = draftArticlesChunk.size();
                this.migratedDraftArticlesCount += processedDraftArticlesCountByTransaction - draftArticlesCountByTransaction.get("notMigratedDraftArticlesCountByTransaction") - draftArticlesCountByTransaction.get("ignoredDraftArticlesCountByTransaction");
                LOG.info("Draft articles migration progress: processed={}/{} succeeded={} ignored={} error={}", new Object[]{processedDraftArticlesCount += processedDraftArticlesCountByTransaction, totalDraftArticlesCount, this.migratedDraftArticlesCount, ignoredDraftArticlesCount += draftArticlesCountByTransaction.get("ignoredDraftArticlesCountByTransaction").intValue(), notMigratedDraftArticlesCount += draftArticlesCountByTransaction.get("notMigratedDraftArticlesCountByTransaction").intValue()});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred when upgrading draft articles:", (Throwable)e);
        }
        if (totalDraftArticlesCount != (long)this.migratedDraftArticlesCount) {
            LOG.warn("End draft articles migration with some errors: total={} succeeded={} ignored={} error={}. It tooks {} ms. The not migrated draft articles will be processed again next startup.", new Object[]{totalDraftArticlesCount, this.migratedDraftArticlesCount, ignoredDraftArticlesCount, notMigratedDraftArticlesCount, System.currentTimeMillis() - startupTime});
            this.upgradeFailed = true;
            throw new IllegalStateException("Some draft articles wasn't executed successfully. It will be re-attempted next startup");
        }
        LOG.info("End draft articles migration successful migration: total={} succeeded={} ignored={} error={}. It tooks {} ms.", new Object[]{totalDraftArticlesCount, this.migratedDraftArticlesCount, ignoredDraftArticlesCount, notMigratedDraftArticlesCount, System.currentTimeMillis() - startupTime});
    }

    public void afterUpgrade() {
        if (!this.upgradeFailed) {
            this.settingService.set(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY, SettingValue.create((Boolean)true));
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext upgradePluginExecutionContext) {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY);
        boolean shouldUpgrade = super.shouldProceedToUpgrade(newVersion, previousGroupVersion, upgradePluginExecutionContext);
        if (!shouldUpgrade && settingValue == null) {
            this.settingService.set(Context.GLOBAL.id(PLUGIN_NAME), Scope.APPLICATION.id(PLUGIN_NAME), PLUGIN_EXECUTED_KEY, SettingValue.create((Boolean)true));
        }
        return shouldUpgrade;
    }

    public boolean isEnabled() {
        String isEnabledProperty = PropertyManager.getProperty((String)"commons.upgrade.{$0}.enable".replace("{$0}", this.getName()));
        return isEnabledProperty != null && isEnabledProperty.equals("true");
    }

    public Map<String, Integer> manageDraftArticles(List<String> draftArticles) {
        int notMigratedDraftArticlesCountByTransaction = 0;
        int ignoredDraftArticlesCountByTransaction = 0;
        HashMap<String, Integer> draftArticlesCountByTransaction = new HashMap<String, Integer>();
        for (String draftArticle : draftArticles) {
            String draftArticleId = draftArticle.split(",")[0];
            String articleActivityId = draftArticle.split(",")[1];
            try {
                ExoSocialActivity articleActivity = this.activityManager.getActivity(articleActivityId);
                String poster = this.identityManager.getIdentity(Long.parseLong(articleActivity.getPosterId())).getRemoteId();
                DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticleId, poster);
                if (draftArticlePage != null) {
                    News news = this.convertdraftArticlePageToNewEntity((Page)draftArticlePage);
                    News article = this.newsService.createNewsArticlePage(news, news.getAuthor());
                    String oldNewsId = this.setArticleActivities(article.getId(), news.getSpaceId(), articleActivity);
                    this.setArticleMetadatasItems(article.getId(), oldNewsId);
                    this.setArticleCreateAndUpdateDate(article.getId(), news.getSpaceId(), (Page)draftArticlePage);
                    LOG.info("Success migrating draft article with id '{}' and activity '{}'", new Object[]{draftArticleId, articleActivityId});
                    continue;
                }
                ++ignoredDraftArticlesCountByTransaction;
                LOG.info("Ignore migrating not found draft article with id '{}' and activity '{}'. Continue to migrate other items", new Object[]{draftArticleId, articleActivityId});
            }
            catch (Exception e) {
                ++notMigratedDraftArticlesCountByTransaction;
                LOG.warn("Error migrating draft article with id '{}'. Continue to migrate other items", new Object[]{draftArticleId, e});
            }
        }
        draftArticlesCountByTransaction.put("notMigratedDraftArticlesCountByTransaction", notMigratedDraftArticlesCountByTransaction);
        draftArticlesCountByTransaction.put("ignoredDraftArticlesCountByTransaction", ignoredDraftArticlesCountByTransaction);
        return draftArticlesCountByTransaction;
    }

    private News convertdraftArticlePageToNewEntity(Page draftArticlePage) throws Exception {
        News news = new News();
        news.setId(draftArticlePage.getId());
        news.setTitle(draftArticlePage.getTitle());
        news.setName(news.getTitle());
        news.setProperties(draftArticlePage.getProperties());
        news.setBody(draftArticlePage.getContent());
        news.setAuthor(draftArticlePage.getAuthor());
        news.setDraftUpdaterUserName(draftArticlePage.getLastUpdater());
        Space space = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
        news.setSpaceId(space.getId());
        news.setPublicationState("posted");
        news.setPublished(false);
        news.setActivityPosted(true);
        news.setCreationDate(draftArticlePage.getCreatedDate());
        news.setUpdateDate(draftArticlePage.getUpdatedDate());
        return news;
    }

    private String setArticleActivities(String articleId, String articleSpaceId, ExoSocialActivity articleActivity) {
        NewsPageObject articleMetaDataObject = new NewsPageObject("newsPage", articleId, null, Long.parseLong(articleSpaceId));
        MetadataItem articleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NewsService.NEWS_METADATA_KEY, (MetadataObject)articleMetaDataObject).stream().findFirst().orElse(null);
        String articleActivities = articleSpaceId + ":" + articleActivity.getId();
        if (articleMetadataItem != null) {
            HashMap<String, CallSite> articleMetadataItemProperties = articleMetadataItem.getProperties();
            if (articleMetadataItemProperties == null) {
                articleMetadataItemProperties = new HashMap<String, CallSite>();
            }
            articleMetadataItemProperties.put("activities", (CallSite)((Object)articleActivities));
            articleMetadataItem.setProperties(articleMetadataItemProperties);
            this.metadataService.updateMetadataItem(articleMetadataItem, articleMetadataItem.getCreatorId(), false);
        }
        Map<String, String> templateParams = articleActivity.getTemplateParams() == null ? new HashMap() : articleActivity.getTemplateParams();
        String oldNewsId = (String)templateParams.get("newsId");
        templateParams.put("newsId", articleId);
        articleActivity.setTemplateParams(templateParams);
        articleActivity.setMetadataObjectId(articleId);
        articleActivity.setMetadataObjectType(NEWS_METADATA_NAME);
        this.activityManager.updateActivity(articleActivity, false);
        return oldNewsId;
    }

    @ExoTransactional
    private void setArticleMetadatasItems(String targetId, String sourceId) throws RepositoryException {
        String string = targetId;
        String string2 = sourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        ContentDraftArticlesUpgrade$AjcClosure1 contentDraftArticlesUpgrade$AjcClosure1 = new ContentDraftArticlesUpgrade$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(contentDraftArticlesUpgrade$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void setArticleCreateAndUpdateDate(String articleId, String articleSpaceId, Page draftArticlePage) throws Exception {
        Page articlePage = this.noteService.getNoteById(articleId);
        if (articlePage != null) {
            Date createdDate = draftArticlePage.getCreatedDate();
            Date updatedDate = draftArticlePage.getUpdatedDate();
            MetadataItem articleMetaDataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NewsService.NEWS_METADATA_KEY, (MetadataObject)new NewsPageObject("newsPage", articleId, null, Long.parseLong(articleSpaceId))).stream().findFirst().orElse(null);
            if (updatedDate != null) {
                articlePage.setUpdatedDate(updatedDate);
                articleMetaDataItem.setUpdatedDate(updatedDate.getTime());
            }
            if (createdDate != null) {
                articlePage.setCreatedDate(createdDate);
                articleMetaDataItem.setCreatedDate(createdDate.getTime());
            }
            this.noteService.updateNote(articlePage);
            this.metadataService.updateMetadataItem(articleMetaDataItem, articleMetaDataItem.getCreatorId(), false);
        }
    }

    static {
        ContentDraftArticlesUpgrade.ajc$preClinit();
        LOG = ExoLogger.getLogger((String)ContentDraftArticlesUpgrade.class.getName());
        NEWS_METADATA_TYPE = new MetadataType(1000L, NEWS_METADATA_NAME);
    }

    static final /* synthetic */ void setArticleMetadatasItems_aroundBody0(ContentDraftArticlesUpgrade ajc$this, String targetId, String sourceId, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        String sqlStatement = "UPDATE SOC_METADATA_ITEMS SET OBJECT_ID = '" + targetId + "' WHERE OBJECT_ID = '" + sourceId + "';";
        Query query = entityManager.createNativeQuery(sqlStatement);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContentDraftArticlesUpgrade.java", ContentDraftArticlesUpgrade.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setArticleMetadatasItems", "org.exoplatform.news.upgrade.ContentDraftArticlesUpgrade", "java.lang.String:java.lang.String", "targetId:sourceId", "javax.jcr.RepositoryException", "void"), 292);
    }
}

