/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.data.PortalKey;

public final class MigrationContext {
    protected static final String CONTEXT_KEY = "PORTAL_MIGRATION_ENTITIES";
    protected static final Context CONTEXT = Context.GLOBAL.id("PORTAL_MIGRATION_ENTITIES");
    protected static final String NAVIGATION_SCOPE = "NAVIGATION";
    public static final String APP_ID_MIGRATION_STATUS_KEY = "APP_ID_MIGRATION_STATUS_KEY";
    public static final String PORTAL_RDBMS_MIGRATION_STATUS_KEY = "PORTAL_RDBMS_MIGRATION_DONE";
    public static final String PORTAL_RDBMS_APP_MIGRATION_KEY = "PORTAL_RDBMS_APP_MIGRATION_DONE";
    public static final String PORTAL_RDBMS_APP_CLEANUP_KEY = "PORTAL_RDBMS_APP_CLEANUP_DONE";
    private static SettingService settingService = null;
    private static boolean forceStop = false;
    private static int siteToMigrateIndex = 0;
    private static List<PortalKey> sitesToMigrate = null;
    private static List<PortalKey> priorizedSitesToMigrate = Collections.synchronizedList(new LinkedList());

    private MigrationContext() {
    }

    public static boolean isApplicationContentIdDone() {
        return MigrationContext.getSettingValue(APP_ID_MIGRATION_STATUS_KEY);
    }

    public static boolean isDone() {
        return MigrationContext.getSettingValue(PORTAL_RDBMS_MIGRATION_STATUS_KEY);
    }

    public static boolean isMigrated(PortalKey siteToMigrateKey) {
        return sitesToMigrate == null || !sitesToMigrate.contains(siteToMigrateKey) || MigrationContext.isDone() || MigrationContext.isMigrated(siteToMigrateKey, PortalEntityType.NAVIGATION) && MigrationContext.isMigrated(siteToMigrateKey, PortalEntityType.PAGE) && MigrationContext.isMigrated(siteToMigrateKey, PortalEntityType.SITE);
    }

    protected static void setApplicationContentIdDone() {
        MigrationContext.updateSettingValue(APP_ID_MIGRATION_STATUS_KEY, true);
    }

    protected static void setDone() {
        MigrationContext.updateSettingValue(PORTAL_RDBMS_MIGRATION_STATUS_KEY, true);
    }

    protected static boolean isAppDone() {
        return MigrationContext.getSettingValue(PORTAL_RDBMS_APP_MIGRATION_KEY);
    }

    protected static void setAppDone() {
        MigrationContext.updateSettingValue(PORTAL_RDBMS_APP_MIGRATION_KEY, true);
    }

    protected static boolean isAppCleanupDone() {
        return MigrationContext.getSettingValue(PORTAL_RDBMS_APP_CLEANUP_KEY);
    }

    protected static void setAppCleanupDone() {
        MigrationContext.updateSettingValue(PORTAL_RDBMS_APP_CLEANUP_KEY, true);
    }

    protected static void setMigrated(PortalKey siteToMigrateKey, PortalEntityType entityType) {
        MigrationContext.getSettingService().set(entityType.getContext(), new Scope(entityType.getScopeType(), siteToMigrateKey.getType()), siteToMigrateKey.getId(), SettingValue.create((Boolean)true));
    }

    protected static boolean isMigrated(PortalKey siteToMigrateKey, PortalEntityType entityType) {
        SettingValue settingValue = MigrationContext.getSettingService().get(entityType.getContext(), new Scope(entityType.getScopeType(), siteToMigrateKey.getType()), siteToMigrateKey.getId());
        return settingValue != null && Boolean.parseBoolean(settingValue.getValue().toString());
    }

    protected static void setPageMigrated(PageKey key) {
        MigrationContext.getSettingService().set(CONTEXT, Scope.PAGE.id(key.getSite().getTypeName() + "::" + key.getSite().getName()), key.getName(), SettingValue.create((Boolean)true));
    }

    protected static boolean isPageMigrated(PageKey key) {
        SettingValue settingValue = MigrationContext.getSettingService().get(CONTEXT, Scope.PAGE.id(key.getSite().getTypeName() + "::" + key.getSite().getName()), key.getName());
        return settingValue != null && Boolean.parseBoolean(settingValue.getValue().toString());
    }

    protected static void resetForceStop() {
        forceStop = false;
    }

    protected static void setForceStop() {
        forceStop = true;
    }

    protected static boolean isForceStop() {
        return forceStop;
    }

    protected static List<PortalKey> getSitesToMigrate() {
        return sitesToMigrate;
    }

    protected static int getSitesCountToMigrate() {
        return sitesToMigrate == null ? 0 : sitesToMigrate.size();
    }

    protected static void addPriorizedSitesToMigrate(PortalKey priorizedSiteToMigrate) {
        priorizedSitesToMigrate.add(priorizedSiteToMigrate);
    }

    protected static PortalKey getNextSiteKeyToMigrate() {
        try {
            while (!priorizedSitesToMigrate.isEmpty()) {
                PortalKey portalKey = priorizedSitesToMigrate.get(0);
                priorizedSitesToMigrate.remove(portalKey);
                int indexOfPriorizedSiteKey = sitesToMigrate.indexOf(portalKey);
                if (indexOfPriorizedSiteKey <= siteToMigrateIndex) continue;
                Collections.swap(sitesToMigrate, indexOfPriorizedSiteKey, siteToMigrateIndex);
                PortalKey portalKey2 = portalKey;
                return portalKey2;
            }
            PortalKey portalKey = sitesToMigrate.get(siteToMigrateIndex);
            return portalKey;
        }
        finally {
            ++siteToMigrateIndex;
        }
    }

    protected static void setSitesToMigrate(List<PortalKey> sitesToMigrate) {
        MigrationContext.sitesToMigrate = sitesToMigrate;
    }

    protected static SettingService getSettingService() {
        if (settingService == null) {
            settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        }
        return settingService;
    }

    protected static void restartTransaction() {
        if (forceStop) {
            return;
        }
        int i = 0;
        boolean success = true;
        do {
            try {
                RequestLifeCycle.end();
                ++i;
            }
            catch (IllegalStateException e) {
                success = false;
            }
        } while (success);
        for (int j = 0; j < i; ++j) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        }
    }

    private static boolean getSettingValue(String key) {
        SettingValue setting = MigrationContext.getSettingService().get(CONTEXT, Scope.GLOBAL.id(null), key);
        if (setting != null) {
            return Boolean.parseBoolean(setting.getValue().toString());
        }
        return false;
    }

    private static void updateSettingValue(String key, Boolean status) {
        MigrationContext.getSettingService().set(CONTEXT, Scope.GLOBAL.id(null), key, SettingValue.create((Boolean)status));
    }

    protected static enum PortalEntityType {
        SITE(CONTEXT, Scope.PORTAL.getName(), "SITE"),
        NAVIGATION(CONTEXT, "NAVIGATION", "SITE NAVIGATION"),
        PAGE(CONTEXT, Scope.PAGE.getName(), "SITE PAGES");

        private Context context;
        private String scopeType;
        private String title;

        private PortalEntityType(Context context, String scopeType, String title) {
            this.context = context;
            this.scopeType = scopeType;
            this.title = title;
        }

        public Context getContext() {
            return this.context;
        }

        public String getScopeType() {
            return this.scopeType;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

