/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.codec.net.QCodec;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.xwiki.xml.XMLUtils;

public class EscapeTool
extends org.apache.velocity.tools.generic.EscapeTool {
    private static final String EQUALS = "=";
    private static final String AND = "&";

    public String xml(Object content) {
        return XMLUtils.escape((Object)content);
    }

    public String quotedPrintable(Object content) {
        if (content != null) {
            try {
                return new QuotedPrintableCodec().encode(String.valueOf(content));
            }
            catch (EncoderException encoderException) {
                // empty catch block
            }
        }
        return null;
    }

    public String q(Object content) {
        if (content != null) {
            try {
                return new QCodec().encode(String.valueOf(content)).replace(' ', '_');
            }
            catch (EncoderException encoderException) {
                // empty catch block
            }
        }
        return null;
    }

    public String b(Object content) {
        if (content != null) {
            try {
                return new BCodec().encode(String.valueOf(content));
            }
            catch (EncoderException encoderException) {
                // empty catch block
            }
        }
        return null;
    }

    public String url(Map<String, ?> parametersMap) {
        StringBuilder queryStringBuilder = new StringBuilder();
        for (Map.Entry<String, ?> entry : parametersMap.entrySet()) {
            Object values;
            if (entry.getKey() == null) continue;
            String cleanKey = this.url(entry.getKey());
            Object mapValues = entry.getValue();
            if (mapValues != null && mapValues.getClass().isArray()) {
                values = (Object[])mapValues;
                for (Object value : values) {
                    this.addQueryStringPair(cleanKey, value, queryStringBuilder);
                }
                continue;
            }
            if (mapValues != null && Collection.class.isAssignableFrom(mapValues.getClass())) {
                values = (Collection)mapValues;
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    Object value = i$.next();
                    this.addQueryStringPair(cleanKey, value, queryStringBuilder);
                }
                continue;
            }
            this.addQueryStringPair(cleanKey, mapValues, queryStringBuilder);
        }
        return queryStringBuilder.toString();
    }

    private void addQueryStringPair(String cleanKey, Object rawValue, StringBuilder queryStringBuilder) {
        String valueAsString = rawValue == null ? "" : String.valueOf(rawValue);
        String cleanValue = this.url(valueAsString);
        if (queryStringBuilder.length() != 0) {
            queryStringBuilder.append(AND);
        }
        queryStringBuilder.append(cleanKey).append(EQUALS).append(cleanValue);
    }
}

