/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Map;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;

public class DrawingSupplierFactory {
    public DrawingSupplier createDrawingSupplier(Map<String, String> parameters) {
        DefaultDrawingSupplier supplier;
        String colorParam = parameters.get("colors");
        if (colorParam != null) {
            ArrayList<Color> colors = new ArrayList<Color>();
            for (String colorAsString : colorParam.split(",")) {
                if (colorAsString.length() != 6) continue;
                int red = Integer.parseInt(colorAsString.substring(0, 2), 16);
                int green = Integer.parseInt(colorAsString.substring(2, 4), 16);
                int blue = Integer.parseInt(colorAsString.substring(4, 6), 16);
                colors.add(new Color(red, green, blue));
            }
            Paint[] paint = new Paint[colors.size()];
            int i = 0;
            for (Color color : colors) {
                paint[i++] = color;
            }
            supplier = new DefaultDrawingSupplier(paint, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
        } else {
            supplier = new DefaultDrawingSupplier();
        }
        return supplier;
    }
}

