/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.jdbc.migration.MigrationContext;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.filter.Filter;

public class MigrationFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger(MigrationFilter.class);
    private static final int MAX_WAIT_ATTEMPTS = 30;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || MigrationContext.isDone()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        WebAppController controller = (WebAppController)PortalContainer.getInstance().getComponentInstanceOfType(WebAppController.class);
        String portalPath = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        Router router = controller.getRouter();
        if (router != null) {
            try {
                Iterator matcher = router.matcher(portalPath, httpRequest.getParameterMap());
                WebRequestHandler handler = null;
                while (handler == null && matcher.hasNext()) {
                    String requestSiteName;
                    String requestSiteType;
                    PortalKey portalKey;
                    Map parameters = (Map)matcher.next();
                    String handlerKey = (String)parameters.get(WebAppController.HANDLER_PARAM);
                    if (handlerKey == null || !((handler = controller.getHandler(handlerKey)) instanceof PortalRequestHandler) || MigrationContext.isMigrated(portalKey = new PortalKey(requestSiteType = (String)parameters.get(PortalRequestHandler.REQUEST_SITE_TYPE), requestSiteName = (String)parameters.get(PortalRequestHandler.REQUEST_SITE_NAME)))) continue;
                    MigrationContext.addPriorizedSitesToMigrate(portalKey);
                    try {
                        int i = 0;
                        do {
                            LOG.info("Wait until site {} / {} migration finishes", new Object[]{requestSiteType, requestSiteName});
                            Thread.sleep(500L);
                        } while (!MigrationContext.isMigrated(portalKey) && ++i < 30);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while checking Portal RDBMS migration status when a user requests a page", (Throwable)e);
            }
        }
        chain.doFilter(request, response);
    }
}

