/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.application.registry.impl.ApplicationRegistryServiceImpl;
import org.exoplatform.application.registry.impl.ContentDefinition;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.pom.config.POMSession;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.workspace.Workspace;

@PrimaryType(name="app:category")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="app")
public abstract class CategoryDefinition {
    public ApplicationRegistryServiceImpl registry;

    @Name
    public abstract String getName();

    @Property(name="gtn:name")
    public abstract String getDisplayName();

    public abstract void setDisplayName(String var1);

    @Property(name="gtn:description")
    public abstract String getDescription();

    public abstract void setDescription(String var1);

    @Property(name="app:creationdate")
    public abstract Date getCreationDate();

    public abstract void setCreationDate(Date var1);

    @Property(name="app:lastmodificationdate")
    public abstract Date getLastModificationDate();

    public abstract void setLastModificationDate(Date var1);

    @Property(name="gtn:access-permissions")
    public abstract List<String> getAccessPermissions();

    public abstract void setAccessPermissions(List<String> var1);

    @OneToMany
    public abstract List<ContentDefinition> getContentList();

    @OneToMany
    public abstract Map<String, ContentDefinition> getContentMap();

    @Create
    public abstract ContentDefinition create();

    public ContentDefinition createContent(String definitionName, ContentType<?> contentType, String contentId) {
        if (definitionName == null) {
            throw new NullPointerException("No null definition name accepted");
        }
        if (contentType == null) {
            throw new NullPointerException("No null content type accepted");
        }
        if (contentId == null) {
            throw new NullPointerException("No null content id accepted");
        }
        POMSession session = this.registry.mopManager.getSession();
        Workspace workspace = session.getWorkspace();
        definitionName = ApplicationType.getType(contentType).getName() + "_" + definitionName;
        Customization customization = workspace.getCustomizationContext().getCustomization(definitionName);
        if (customization == null) {
            workspace.getCustomizationContext().customize(definitionName, contentType, contentId, null);
        }
        ContentDefinition content = this.create();
        Map<String, ContentDefinition> contents = this.getContentMap();
        contents.put(definitionName, content);
        return content;
    }
}

