/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import java.util.ArrayList;
import java.util.List;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.ContextualTask;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.web.security.GateInTokenStore;
import org.exoplatform.web.security.HashedToken;
import org.exoplatform.web.security.TokenContainer;
import org.exoplatform.web.security.TokenEntry;
import org.exoplatform.web.security.security.TokenExistsException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.security.Credentials;

public class JCRGateInTokenStorage
implements GateInTokenStore {
    private static final String LIFECYCLE_NAME = "chromatic-lifecycle";
    private final Logger log = LoggerFactory.getLogger(JCRGateInTokenStorage.class);
    private ChromatticLifeCycle chromatticLifeCycle;
    private String lifecycleName = "autologin";

    public JCRGateInTokenStorage(InitParams initParams, ChromatticManager chromatticManager) {
        ValueParam param;
        if (initParams != null && (param = initParams.getValueParam(LIFECYCLE_NAME)) != null) {
            this.lifecycleName = param.getValue();
        }
        this.chromatticLifeCycle = chromatticManager.getLifeCycle(this.lifecycleName);
    }

    public void cleanLegacy() {
        new TokenTask<Void>(){

            @Override
            protected Void execute(SessionContext context) {
                ChromatticSession session = context.getSession();
                TokenContainer container = (TokenContainer)session.findByPath(TokenContainer.class, JCRGateInTokenStorage.this.lifecycleName);
                if (container != null) {
                    container.cleanLegacyTokens();
                } else {
                    session.insert(TokenContainer.class, JCRGateInTokenStorage.this.lifecycleName);
                }
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public void saveToken(final GateInTokenStore.TokenData data) throws TokenExistsException {
        boolean saved = (Boolean)new TokenTask<Boolean>(){

            @Override
            protected Boolean execute(SessionContext context) {
                try {
                    TokenContainer tokenContainer = this.getTokenContainer();
                    tokenContainer.saveToken(context.getSession(), data.tokenId, data.hash, data.payload, data.expirationTime);
                }
                catch (TokenExistsException e) {
                    return false;
                }
                return true;
            }
        }.executeWith(this.chromatticLifeCycle);
        if (!saved) {
            throw new TokenExistsException();
        }
    }

    public GateInTokenStore.TokenData getToken(final String tokenId) {
        return (GateInTokenStore.TokenData)new TokenTask<GateInTokenStore.TokenData>(){

            @Override
            protected GateInTokenStore.TokenData execute(SessionContext context) {
                HashedToken hashedToken;
                TokenEntry en = this.getTokenContainer().getTokens().get(tokenId);
                if (en != null && (hashedToken = this.getMixin(en, HashedToken.class)) != null && hashedToken.getHashedToken() != null) {
                    return new GateInTokenStore.TokenData(en.getId(), hashedToken.getHashedToken(), new Credentials(en.getUserName(), en.getPassword()), en.getExpirationTime());
                }
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public void deleteToken(final String tokenId) {
        new TokenTask<Boolean>(){

            @Override
            protected Boolean execute(SessionContext context) {
                this.getTokenContainer().removeToken(tokenId);
                return true;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public void deleteTokenOfUser(final String user) {
        new TokenTask<Void>(){

            @Override
            protected Void execute(SessionContext context) {
                QueryResult<TokenEntry> result = this.findTokensOfUser(user);
                while (result.hasNext()) {
                    TokenEntry en = (TokenEntry)result.next();
                    en.remove();
                }
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public void deleteAll() {
        new TokenTask<Void>(){

            @Override
            protected Void execute(SessionContext context) {
                TokenContainer container = this.getTokenContainer();
                if (container != null && container.size() > 0) {
                    container.removeAll();
                }
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public void cleanExpired() {
        new TokenTask<Void>(){

            @Override
            protected Void execute(SessionContext context) {
                this.getTokenContainer().cleanExpiredTokens();
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public long size() {
        return (Long)new TokenTask<Long>(){

            @Override
            protected Long execute(SessionContext context) {
                return this.getTokenContainer().size();
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public List<GateInTokenStore.TokenData> getAll(final long offset, final long limit) {
        return (List)new TokenTask<List<GateInTokenStore.TokenData>>(){

            @Override
            protected List<GateInTokenStore.TokenData> execute(SessionContext context) {
                ArrayList<GateInTokenStore.TokenData> result = new ArrayList<GateInTokenStore.TokenData>();
                QueryResult<TokenEntry> entries = this.findAll(offset, limit);
                if (entries != null && entries.size() > 0) {
                    while (entries.hasNext()) {
                        TokenEntry en = (TokenEntry)entries.next();
                        HashedToken hashedToken = this.getMixin(en, HashedToken.class);
                        if (hashedToken == null || hashedToken.getHashedToken() == null) continue;
                        result.add(new GateInTokenStore.TokenData(en.getId(), hashedToken.getHashedToken(), new Credentials(en.getUserName(), en.getPassword()), en.getExpirationTime()));
                    }
                }
                return result;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    private abstract class TokenTask<V>
    extends ContextualTask<V> {
        private TokenTask() {
        }

        protected final TokenContainer getTokenContainer() {
            SessionContext ctx = JCRGateInTokenStorage.this.chromatticLifeCycle.getContext();
            ChromatticSession session = ctx.getSession();
            return (TokenContainer)session.findByPath(TokenContainer.class, JCRGateInTokenStorage.this.lifecycleName);
        }

        protected final <A> A getMixin(Object o, Class<A> type) {
            SessionContext ctx = JCRGateInTokenStorage.this.chromatticLifeCycle.getContext();
            ChromatticSession session = ctx.getSession();
            return (A)session.getEmbedded(o, type);
        }

        protected final QueryResult<TokenEntry> findTokensOfUser(String user) {
            SessionContext ctx = JCRGateInTokenStorage.this.chromatticLifeCycle.getContext();
            ChromatticSession session = ctx.getSession();
            TokenContainer tokenContainer = this.getTokenContainer();
            String statement = new StringBuilder(128).append("jcr:path LIKE '").append(session.getPath((Object)tokenContainer)).append("/%'").append(" AND username='").append(Utils.queryEscape((String)user)).append("'").toString();
            return session.createQueryBuilder(TokenEntry.class).where(statement).get().objects();
        }

        protected final QueryResult<TokenEntry> findAll(long offset, long limit) {
            SessionContext ctx = JCRGateInTokenStorage.this.chromatticLifeCycle.getContext();
            ChromatticSession session = ctx.getSession();
            TokenContainer tokenContainer = this.getTokenContainer();
            if (tokenContainer == null) {
                return null;
            }
            String statement = new StringBuilder(128).append("jcr:path LIKE '").append(session.getPath((Object)tokenContainer)).append("/%'").toString();
            return session.createQueryBuilder(TokenEntry.class).where(statement).get().objects(Long.valueOf(offset), Long.valueOf(limit));
        }
    }
}

