/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.serializer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.xml.XMLConfiguration;
import org.xwiki.filter.xml.internal.parameter.ParameterManager;
import org.xwiki.filter.xml.internal.serializer.DefaultXMLSerializer;
import org.xwiki.filter.xml.serializer.XMLSerializerFactory;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
public class DefaultXMLSerializerFactory
implements XMLSerializerFactory {
    @Inject
    private ParameterManager parameterManager;
    @Inject
    private FilterDescriptorManager descriptorManager;
    @Inject
    private ConverterManager converter;

    @Override
    public <T> T createSerializer(Class<T> filterInterface, Result xmlResult, XMLConfiguration configuration) throws XMLStreamException, FactoryConfigurationError {
        return this.createSerializer(new Class[]{filterInterface}, xmlResult, configuration);
    }

    @Override
    public <T> T createSerializer(Class<?>[] filterInterfaces, Result xmlResult, XMLConfiguration configuration) throws XMLStreamException, FactoryConfigurationError {
        DefaultXMLSerializer handler = new DefaultXMLSerializer(xmlResult, this.parameterManager, this.descriptorManager.getFilterDescriptor((Class[])filterInterfaces), this.converter, configuration);
        return (T)Proxy.newProxyInstance(filterInterfaces[0].getClassLoader(), filterInterfaces, (InvocationHandler)handler);
    }
}

