/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.jira.displayer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jdom2.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.internal.macro.jira.displayer.AbstractJIRADisplayer;
import org.xwiki.rendering.macro.jira.JIRAMacroParameters;

@Component
@Named(value="enum")
@Singleton
public class EnumJIRADisplayer
extends AbstractJIRADisplayer {
    private static final List<String> FIELDS = Arrays.asList("status", "key");

    @Override
    public List<Block> display(Collection<Element> issues, JIRAMacroParameters parameters) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Iterator<Element> issueIt = issues.iterator();
        while (issueIt.hasNext()) {
            Element issue = issueIt.next();
            Iterator<String> it = this.getFields(parameters).iterator();
            while (it.hasNext()) {
                String field = it.next();
                blocks.addAll(this.getFieldDisplayer(field).displayField(field, issue));
                if (!it.hasNext()) continue;
                blocks.add((Block)new SpaceBlock());
            }
            if (!issueIt.hasNext()) continue;
            blocks.add((Block)new SpaceBlock());
        }
        return blocks;
    }

    @Override
    protected List<String> getDefaultFields() {
        return FIELDS;
    }
}

