/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.chromattic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.UndeclaredRepositoryException;
import org.exoplatform.commons.chromattic.AbstractContext;
import org.exoplatform.commons.chromattic.ChromatticImpl;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.LocalContext;
import org.exoplatform.commons.chromattic.PortalSessionLifeCycle;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.chromattic.Synchronization;
import org.exoplatform.commons.chromattic.SynchronizedContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ChromatticLifeCycle
extends BaseComponentPlugin {
    private static final Map<String, ChromatticBuilder.Option<?>> RECOGNIZED_OPTIONS;
    private final String domainName;
    private final String workspaceName;
    Chromattic realChromattic;
    private ChromatticImpl chromattic;
    ChromatticManager manager;
    private final List<String> entityClassNames;
    final ThreadLocal<LocalContext> currentContext = new ThreadLocal();
    final Logger log = LoggerFactory.getLogger(ChromatticLifeCycle.class);
    private final Map<String, String> optionMap;

    public ChromatticLifeCycle(InitParams params) {
        HashMap<String, String> options = new HashMap<String, String>();
        PropertiesParam pp = params.getPropertiesParam("options");
        if (pp != null) {
            options.putAll((Map<String, String>)pp.getProperties());
        }
        this.domainName = params.getValueParam("domain-name").getValue();
        this.workspaceName = params.getValueParam("workspace-name").getValue();
        this.entityClassNames = params.getValuesParam("entities").getValues();
        this.optionMap = options;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public final String getRepositoryName() {
        try {
            return this.manager.repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException("JCR exceptions are really bad", e);
        }
    }

    public final String getWorkspaceName() {
        return this.workspaceName;
    }

    public final Chromattic getChromattic() {
        return this.chromattic;
    }

    public final ChromatticManager getManager() {
        return this.manager;
    }

    AbstractContext getLoginContext() {
        Synchronization sync = this.manager.getSynchronization();
        if (sync != null) {
            return sync.getContext(this.domainName);
        }
        return this.currentContext.get();
    }

    public final SessionContext getContext() {
        return this.getContext(false);
    }

    public final SessionContext getContext(boolean peek) {
        this.log.trace((Object)"Requesting context");
        Synchronization sync = this.manager.getSynchronization();
        if (sync != null) {
            this.log.trace((Object)("Found synchronization about to get the current context for chromattic " + this.domainName));
            SynchronizedContext context = sync.getContext(this.domainName);
            if (context == null && !peek) {
                this.log.trace((Object)"No current context found, about to open one");
                context = sync.openContext(this);
            } else {
                this.log.trace((Object)"Found a context and will return it");
            }
            return context;
        }
        this.log.trace((Object)"No active synchronization about to try the current local context");
        LocalContext localContext = this.currentContext.get();
        this.log.trace((Object)("Found local context " + localContext));
        return localContext;
    }

    final SessionContext openSynchronizedContext() {
        this.log.trace((Object)"Opening a global context");
        AbstractContext context = (AbstractContext)this.getContext(true);
        if (context != null) {
            String msg = "A global context is already opened";
            this.log.trace((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.log.trace((Object)"Ok, no global context found, asking current synchronization");
        Synchronization sync = this.manager.getSynchronization();
        if (sync == null) {
            String msg = "Need global synchronization for opening a global context";
            this.log.trace((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.log.trace((Object)"Opening a global context for the related sync");
        return sync.openContext(this);
    }

    public final SessionContext openContext() {
        this.log.trace((Object)"Opening a context");
        AbstractContext context = (AbstractContext)this.getContext(true);
        if (context != null) {
            String msg = "A context is already opened";
            this.log.trace((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.log.trace((Object)"Ok, no context found, asking current synchronization");
        Synchronization sync = this.manager.getSynchronization();
        if (sync != null) {
            this.log.trace((Object)"Found a synchronization, about to open a global context");
            context = sync.openContext(this);
        } else {
            this.log.trace((Object)"Not synchronization found, about to a local context");
            LocalContext localContext = new LocalContext(this);
            this.currentContext.set(localContext);
            this.onOpenSession(localContext);
            context = localContext;
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeContext(boolean save) {
        this.log.trace((Object)("Requesting for context close with save=" + save + " going to look for any context"));
        AbstractContext context = (AbstractContext)this.getContext(true);
        if (context == null) {
            String msg = "Cannot close non existing context";
            this.log.trace((Object)msg);
            throw new IllegalStateException(msg);
        }
        Synchronization sync = this.manager.getSynchronization();
        if (sync != null) {
            sync.close(this, save);
        } else {
            try {
                context.close(save);
            }
            finally {
                this.currentContext.set(null);
            }
            this.onCloseSession(context);
        }
    }

    protected void onOpenSession(SessionContext context) {
    }

    protected void onCloseSession(SessionContext context) {
    }

    Session doLogin() throws RepositoryException {
        AbstractContext loginContext = this.getLoginContext();
        if (loginContext == null) {
            throw new IllegalStateException("Could not obtain a login context");
        }
        return loginContext.doLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        this.log.debug((Object)("About to setup Chromattic life cycle " + this.domainName));
        ChromatticBuilder builder = ChromatticBuilder.create();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (String string : this.entityClassNames) {
            String fqn = string.trim();
            this.log.debug((Object)("Adding class " + fqn + " to life cycle " + this.domainName));
            Class<?> entityClass = cl.loadClass(fqn);
            builder.add(entityClass);
        }
        PortalSessionLifeCycle.bootContext.set(this);
        try {
            for (Map.Entry entry : this.optionMap.entrySet()) {
                ChromatticBuilder.Option<?> option = RECOGNIZED_OPTIONS.get(entry.getKey());
                if (option == null) continue;
                this.log.debug((Object)("Setting Chromattic option " + entry));
                this.setOption(builder, option, (String)entry.getValue());
            }
            builder.setOptionValue(ChromatticBuilder.SESSION_LIFECYCLE_CLASSNAME, (Object)PortalSessionLifeCycle.class.getName());
            this.log.debug((Object)("Building Chromattic " + this.domainName));
            this.realChromattic = builder.build();
            this.chromattic = new ChromatticImpl(this);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not start Chromattic " + this.domainName), (Throwable)e);
        }
        finally {
            PortalSessionLifeCycle.bootContext.set(null);
        }
    }

    private <D> void setOption(ChromatticBuilder builder, ChromatticBuilder.Option<D> option, String value) {
        this.log.debug((Object)("Setting Chromattic option " + option.getDisplayName()));
        builder.setOptionValue(option, option.getInstance(value).getValue());
    }

    public final void stop() {
    }

    static {
        HashMap options = new HashMap();
        for (ChromatticBuilder.Option option : new ChromatticBuilder.Option[]{ChromatticBuilder.JCR_OPTIMIZE_ENABLED, ChromatticBuilder.JCR_OPTIMIZE_HAS_NODE_ENABLED, ChromatticBuilder.JCR_OPTIMIZE_HAS_PROPERTY_ENABLED, ChromatticBuilder.OBJECT_FORMATTER_CLASSNAME, ChromatticBuilder.ROOT_NODE_PATH, ChromatticBuilder.CREATE_ROOT_NODE}) {
            options.put(option.getName(), option);
        }
        RECOGNIZED_OPTIONS = options;
    }
}

