/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config;

import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.TaskExecutor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExecutorDispatcher
implements TaskExecutor {
    private final Log log = ExoLogger.getLogger(this.getClass());
    private static final String[] padding = new String[]{"    ", "   ", "  ", " "};

    @Override
    public <V> V execute(POMSession session, POMTask<V> task) throws Exception {
        if (this.log.isDebugEnabled()) {
            String s = task.toString();
            this.log.debug((Object)("Executing " + s + ""));
            long t0 = System.currentTimeMillis();
            V v = session.execute(task);
            long t1 = System.currentTimeMillis();
            String t = "" + (t1 - t0);
            if (t.length() < 4) {
                t = padding[t.length()] + t;
                this.log.debug((Object)("Executed [" + t + "] " + s + ""));
            } else {
                this.log.debug((Object)("Executed in " + t + " " + s + ""));
            }
            return v;
        }
        return session.execute(task);
    }
}

