/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.jira.displayer.field;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jdom2.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.jira.JIRAFieldDisplayer;

@Component
@Named(value="key")
@Singleton
public class KeyJIRAFieldDisplayer
implements JIRAFieldDisplayer {
    @Override
    public List<Block> displayField(String fieldName, Element issue) {
        List<Block> result = Collections.emptyList();
        String key = issue.getChildText("key");
        if (key != null) {
            String link = issue.getChildText("link");
            List<Block> labelBlocks = Arrays.asList(new VerbatimBlock(key, true));
            String resolutionId = issue.getChild("resolution").getAttributeValue("id");
            if (!resolutionId.equals("-1")) {
                labelBlocks = Arrays.asList(new FormatBlock(labelBlocks, Format.STRIKEDOUT));
            }
            if (link != null) {
                ResourceReference reference = new ResourceReference(link, ResourceType.URL);
                result = Arrays.asList(new LinkBlock(labelBlocks, reference, true));
            } else {
                result = labelBlocks;
            }
        }
        return result;
    }
}

