/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.introspection;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.VelMethod;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.velocity.introspection.AbstractChainableUberspector;

public class MethodArgumentsUberspector
extends AbstractChainableUberspector
implements RuntimeServicesAware {
    private ConverterManager converterManager;

    public void setRuntimeServices(RuntimeServices runtimeServices) {
        ComponentManager componentManager = (ComponentManager)runtimeServices.getApplicationAttribute((Object)ComponentManager.class.getName());
        try {
            this.converterManager = (ConverterManager)componentManager.getInstance(ConverterManager.class);
        }
        catch (ComponentLookupException e) {
            this.log.warn((Object)("Failed to initialize " + this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
        Object[] convertedArguments;
        VelMethod method = super.getMethod(obj, methodName, args, i);
        if (method == null && this.converterManager != null && (convertedArguments = this.convertArguments(obj, methodName, args)) != null && (method = super.getMethod(obj, methodName, convertedArguments, i)) != null) {
            method = new ConvertingVelMethod(method);
        }
        return method;
    }

    private Object[] convertArguments(Object obj, String methodName, Object[] args) {
        for (Method method : obj.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(methodName) || method.getParameterTypes().length != args.length) continue;
            try {
                return this.convertArguments(args, method.getParameterTypes());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private Object[] convertArguments(Object[] arguments, Class<?>[] parameterTypes) {
        Object[] convertedArguments = Arrays.copyOf(arguments, arguments.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (arguments[i] == null || parameterTypes[i].isInstance(arguments[i])) continue;
            convertedArguments[i] = this.converterManager.convert(parameterTypes[i], arguments[i]);
        }
        return convertedArguments;
    }

    private class ConvertingVelMethod
    implements VelMethod {
        private VelMethod innerMethod;

        public ConvertingVelMethod(VelMethod realMethod) {
            this.innerMethod = realMethod;
        }

        public Object invoke(Object o, Object[] params) throws Exception {
            return this.innerMethod.invoke(o, MethodArgumentsUberspector.this.convertArguments(o, this.innerMethod.getMethodName(), params));
        }

        public boolean isCacheable() {
            return this.innerMethod.isCacheable();
        }

        public String getMethodName() {
            return this.innerMethod.getMethodName();
        }

        public Class<?> getReturnType() {
            return this.innerMethod.getReturnType();
        }
    }
}

