/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class EntityReferenceSet {
    private EntityReferenceEntry includes;
    private EntityReferenceEntry excludes;

    private void add(EntityReference reference, EntityReferenceEntry entry) {
        EntityReferenceEntry currentEntry = entry;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            while (currentEntry.childrenType != null && currentEntry.childrenType.compareTo(element.getType()) < 0) {
                currentEntry = currentEntry.add();
            }
            if (currentEntry.childrenType == null || currentEntry.childrenType == element.getType()) {
                currentEntry.childrenType = element.getType();
                currentEntry = currentEntry.add(element.getType(), element.getName(), element.getParameters());
                continue;
            }
            EntityReferenceEntry newEntry = new EntityReferenceEntry(currentEntry);
            currentEntry.reset();
            currentEntry.add(newEntry);
        }
    }

    public EntityReferenceSet includes(EntityReference reference) {
        if (this.includes == null) {
            this.includes = new EntityReferenceEntry();
        }
        this.add(reference, this.includes);
        return this;
    }

    public EntityReferenceSet excludes(EntityReference reference) {
        if (this.excludes == null) {
            this.excludes = new EntityReferenceEntry();
        }
        this.add(reference, this.excludes);
        return this;
    }

    private boolean matchesInclude(EntityReference reference) {
        if (this.includes == null) {
            return true;
        }
        EntityReferenceEntry currentEntry = this.includes;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            if (currentEntry.children == null) {
                return true;
            }
            if (currentEntry.childrenType != element.getType()) continue;
            EntityReferenceEntry nameEntry = currentEntry.children.get(element.getName());
            if (nameEntry == null) {
                currentEntry = currentEntry.children.get(null);
                if (currentEntry == null) {
                    return false;
                }
            } else {
                currentEntry = nameEntry;
            }
            if (currentEntry.matches(element)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesExclude(EntityReference reference) {
        if (this.excludes == null) {
            return true;
        }
        EntityReferenceEntry currentEntry = this.excludes;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            if (currentEntry.children == null) {
                return false;
            }
            if (currentEntry.childrenType != element.getType()) continue;
            EntityReferenceEntry nameEntry = currentEntry.children.get(element.getName());
            if (nameEntry == null) {
                currentEntry = currentEntry.children.get(null);
                if (currentEntry == null) {
                    return true;
                }
            } else {
                currentEntry = nameEntry;
            }
            if (currentEntry.matches(element)) continue;
            return true;
        }
        return currentEntry.children != null || !currentEntry.parameters.isEmpty() && CollectionUtils.intersection(currentEntry.parameters.keySet(), reference.getParameters().keySet()).isEmpty();
    }

    public boolean matches(EntityReference reference) {
        return this.matchesInclude(reference) && this.matchesExclude(reference);
    }

    private static class EntityReferenceEntry {
        public EntityType type;
        public String name;
        public Map<String, Serializable> parameters;
        public EntityType childrenType;
        public Map<String, EntityReferenceEntry> children;

        public EntityReferenceEntry() {
        }

        public EntityReferenceEntry(EntityType type, String name, Map<String, Serializable> parameters) {
            this.type = type;
            this.name = name;
            this.parameters = parameters;
        }

        public EntityReferenceEntry(EntityReferenceEntry entry) {
            this(entry.type, entry.name, entry.parameters);
            this.childrenType = entry.childrenType;
            this.children = entry.children;
        }

        public EntityReferenceEntry add() {
            return this.add(null, null, null);
        }

        public void add(EntityReferenceEntry entry) {
            if (this.children == null) {
                this.children = new HashMap<String, EntityReferenceEntry>();
            }
            this.children.put(entry.name, entry);
        }

        public EntityReferenceEntry add(EntityType entityType, String name, Map<String, Serializable> entityParameters) {
            EntityReferenceEntry entry;
            if (this.children == null) {
                this.children = new HashMap<String, EntityReferenceEntry>();
            }
            if ((entry = this.children.get(name)) == null) {
                entry = new EntityReferenceEntry(entityType, name, entityParameters);
                this.children.put(name, entry);
            }
            return entry;
        }

        public void reset() {
            this.childrenType = null;
            this.children = null;
        }

        public boolean matches(EntityReference reference) {
            if (this.parameters == null) {
                return true;
            }
            Map<String, Serializable> referenceParameters = reference.getParameters();
            for (Map.Entry<String, Serializable> mapEntry : this.parameters.entrySet()) {
                if (!referenceParameters.containsKey(mapEntry.getKey()) || ObjectUtils.equals((Object)mapEntry.getValue(), (Object)referenceParameters.get(mapEntry.getKey()))) continue;
                return false;
            }
            return true;
        }
    }
}

