/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.site;

import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.management.operations.AbstractMopOperationHandler;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

public abstract class AbstractSiteOperationHandler
extends AbstractMopOperationHandler {
    @Override
    protected final void execute(OperationContext operationContext, ResultHandler resultHandler, Workspace workspace, ObjectType<Site> siteType) throws ResourceNotFoundException, OperationException {
        String operationName = operationContext.getOperationName();
        PathAddress address = operationContext.getAddress();
        String siteName = address.resolvePathTemplate("site-name");
        if (siteName == null) {
            throw new OperationException(operationName, "No site name specified.");
        }
        SiteKey siteKey = this.getSiteKey(siteType, siteName);
        Site site = workspace.getSite(siteType, siteKey.getName());
        if (site == null) {
            throw new ResourceNotFoundException("No site found for site " + siteKey);
        }
        this.execute(operationContext, resultHandler, site);
    }

    protected abstract void execute(OperationContext var1, ResultHandler var2, Site var3) throws ResourceNotFoundException, OperationException;
}

