/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config.tasks;

import java.util.List;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.cache.CacheableDataTask;
import org.exoplatform.portal.pom.config.cache.DataAccessMode;
import org.exoplatform.portal.pom.config.tasks.Mapper;
import org.exoplatform.portal.pom.data.ModelChange;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PageKey;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

public abstract class PageTask {
    protected final String ownerType;
    protected final String ownerId;
    protected final String name;
    protected final PageKey key;
    protected final ObjectType<? extends Site> siteType;

    protected PageTask(PageKey key) {
        this.key = key;
        this.ownerType = key.getType();
        this.ownerId = key.getId();
        this.name = key.getName();
        this.siteType = Mapper.parseSiteType(this.ownerType);
    }

    public static class Load
    extends PageTask
    implements CacheableDataTask<PageKey, PageData> {
        public Load(PageKey key) {
            super(key);
        }

        @Override
        public DataAccessMode getAccessMode() {
            return DataAccessMode.READ;
        }

        @Override
        public PageKey getKey() {
            return this.key;
        }

        @Override
        public Class<PageData> getValueType() {
            return PageData.class;
        }

        @Override
        public PageData run(POMSession session) {
            Page root;
            Page pages;
            Page page;
            Workspace workspace = session.getWorkspace();
            Site site = workspace.getSite(this.siteType, this.ownerId);
            if (site != null && (page = (pages = (root = site.getRootPage()).getChild("pages")).getChild(this.name)) != null) {
                return new Mapper(session).load(page);
            }
            return null;
        }

        public String toString() {
            return "PageTask.Load[ownerType=" + this.ownerType + ",ownerId=" + this.ownerId + "name," + this.name + "]";
        }
    }

    public static class Save
    extends PageTask
    implements CacheableDataTask<PageKey, Void> {
        private final PageData page;
        private List<ModelChange> changes;

        public Save(PageData page) {
            super(page.getKey());
            this.page = page;
        }

        @Override
        public DataAccessMode getAccessMode() {
            return this.page.getStorageId() != null ? DataAccessMode.WRITE : DataAccessMode.CREATE;
        }

        @Override
        public Class<Void> getValueType() {
            return Void.class;
        }

        @Override
        public PageKey getKey() {
            return this.key;
        }

        @Override
        public Void run(POMSession session) {
            Workspace workspace = session.getWorkspace();
            Site site = workspace.getSite(this.siteType, this.ownerId);
            if (site == null) {
                throw new IllegalArgumentException("Cannot insert page " + this.page + " as the corresponding portal " + this.ownerId + " with type " + this.siteType + " does not exist");
            }
            Mapper mapper = new Mapper(session);
            this.changes = mapper.save(this.page, site, this.name);
            return null;
        }

        public List<ModelChange> getChanges() {
            return this.changes;
        }

        public String toString() {
            return "PageTask.Save[ownerType=" + this.ownerType + ",ownerId=" + this.ownerId + "name," + this.name + "]";
        }
    }
}

