/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.parameter;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.xml.internal.XMLUtils;
import org.xwiki.filter.xml.internal.parameter.InputStreamConverter;
import org.xwiki.filter.xml.internal.parameter.ParameterManager;
import org.xwiki.filter.xml.internal.parameter.XMLCollectionConverter;
import org.xwiki.filter.xml.internal.parameter.XMLFilterElementParametersConverter;
import org.xwiki.filter.xml.internal.parameter.XMLMapConverter;
import org.xwiki.filter.xml.internal.parameter.XMLTreeMarshallingStrategy;

@Component
public class XStreamParameterManager
implements ParameterManager,
Initializable {
    public static final String DDEFAULTTYPE_NAME = "defaultType";
    @Inject
    private Logger logger;
    private XStream xstream;
    private StaxDriver staxDriver;

    public void initialize() throws InitializationException {
        this.staxDriver = new StaxDriver();
        this.xstream = new XStream((HierarchicalStreamDriver)this.staxDriver);
        this.xstream.setMarshallingStrategy((MarshallingStrategy)new XMLTreeMarshallingStrategy());
        this.xstream.registerConverter((Converter)new XMLCollectionConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new XMLMapConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new XMLFilterElementParametersConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new InputStreamConverter());
        this.xstream.alias("parameters", FilterEventParameters.class);
        this.xstream.alias("map", LinkedHashMap.class);
        this.xstream.alias("input-stream", InputStream.class);
    }

    @Override
    public void serialize(Type type, Object object, XMLStreamWriter xmlStreamWriter) {
        StaxWriter staxWriter;
        Class typeClass = ReflectionUtils.getTypeClass((Type)type);
        if (typeClass != null && ObjectUtils.equals((Object)XMLUtils.emptyValue(typeClass), (Object)object)) {
            return;
        }
        try {
            staxWriter = this.staxDriver.createStaxWriter(xmlStreamWriter, false);
        }
        catch (XMLStreamException e) {
            this.logger.error("Failed to create new instance of StaxWriter", (Throwable)e);
            return;
        }
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        if (type != Object.class) {
            dataHolder.put((Object)DDEFAULTTYPE_NAME, (Object)type);
        }
        this.xstream.marshal(object, (HierarchicalStreamWriter)staxWriter, (DataHolder)dataHolder);
    }

    @Override
    public Object unSerialize(Type type, Element rootElement) throws ClassNotFoundException {
        Object value;
        if (type != null && !rootElement.hasChildNodes() && (value = XMLUtils.emptyValue(ReflectionUtils.getTypeClass((Type)type))) != null) {
            return value;
        }
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        if (type == Object.class) {
            dataHolder.put((Object)DDEFAULTTYPE_NAME, String.class);
        } else {
            dataHolder.put((Object)DDEFAULTTYPE_NAME, (Object)type);
        }
        return this.xstream.unmarshal((HierarchicalStreamReader)new DomReader(rootElement), null, (DataHolder)dataHolder);
    }
}

