/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.migration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.jpa.EntityConverter;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.PageVersionDAO;
import org.exoplatform.wiki.jpa.dao.TemplateDAO;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.TemplateEntity;
import org.exoplatform.wiki.migration.PageContentMigrationService;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiService;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.syntax.Syntax;

public class PageContentMigrationServiceImpl
implements PageContentMigrationService {
    private static final Log LOG = ExoLogger.getLogger(PageContentMigrationServiceImpl.class);
    private RenderingService renderingService;
    private WikiService wikiService;
    private EntityManagerService entityManagerService;
    private ConfigurationManager configurationManager;
    private PageDAO pageDAO;
    private PageVersionDAO pageVersionDAO;
    private TemplateDAO templateDAO;

    public PageContentMigrationServiceImpl(RenderingService renderingService, WikiService wikiService, EntityManagerService entityManagerService, ConfigurationManager configurationManager, PageDAO pageDAO, PageVersionDAO pageVersionDAO, TemplateDAO templateDAO) {
        this.renderingService = renderingService;
        this.wikiService = wikiService;
        this.entityManagerService = entityManagerService;
        this.configurationManager = configurationManager;
        this.pageDAO = pageDAO;
        this.pageVersionDAO = pageVersionDAO;
        this.templateDAO = templateDAO;
    }

    public void migratePage(Page page) throws Exception {
        if (page.getSyntax() == null || page.getSyntax().equals(Syntax.XWIKI_2_0.toIdString())) {
            LOG.info((Object)("Convert wiki page " + page.getId() + " to HTML"));
            this.setWikiContext(page);
            String markup = this.convertContent(page.getContent());
            page.setContent(markup);
            page.setSyntax(Syntax.XHTML_1_0.toIdString());
            this.wikiService.updatePage(page, null);
        }
    }

    public String convertContent(String xwikiContent) throws Exception {
        return this.renderingService.render(xwikiContent, Syntax.XWIKI_2_0.toIdString(), Syntax.XHTML_1_0.toIdString(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateAllPages() {
        int batchSize = 10;
        int nbMigratedPages = 0;
        ArrayList<Page> pagesInError = new ArrayList<Page>();
        try {
            List pagesToMigrate;
            this.entityManagerService.startRequest(ExoContainerContext.getCurrentContainer());
            Long nbPagesToMigrate = this.pageDAO.countPagesBySyntax(Syntax.XWIKI_2_0.toIdString());
            if (nbPagesToMigrate == null || nbPagesToMigrate == 0L) {
                LOG.info((Object)"Wiki pages syntax migration - No Wiki page to migrate from XWiki syntax to HTML");
                return;
            }
            LOG.info((Object)"==== Starting Wiki pages syntax migration");
            LOG.info((Object)("Wiki pages syntax migration - Number of pages = " + nbPagesToMigrate));
            do {
                this.entityManagerService.endRequest(ExoContainerContext.getCurrentContainer());
                this.entityManagerService.startRequest(ExoContainerContext.getCurrentContainer());
                pagesToMigrate = this.pageDAO.findAllBySyntax(Syntax.XWIKI_2_0.toIdString(), 0, batchSize);
                for (PageEntity pageEntity : pagesToMigrate) {
                    Page page = null;
                    try {
                        page = EntityConverter.convertPageEntityToPage((PageEntity)pageEntity);
                        this.migratePage(page);
                        ++nbMigratedPages;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while migrating wiki page " + (page != null ? page.getId() : "") + " to HTML"), (Throwable)e);
                        pagesInError.add(page);
                        pageEntity.setSyntax("ERROR");
                        this.pageDAO.update((Object)pageEntity);
                    }
                }
                LOG.info((Object)("Wiki pages syntax migration - Progress : " + nbMigratedPages + "/" + nbPagesToMigrate));
            } while (pagesToMigrate != null && pagesToMigrate.size() == batchSize);
            LOG.info((Object)("==== Wiki pages syntax migration - Migration finished - Number of migrated pages = " + nbMigratedPages + ", number of errors = " + pagesInError.size()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while migrating wiki pages fom XWiki syntax to HTML", (Throwable)e);
        }
        finally {
            this.entityManagerService.endRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateAllPagesVersions() {
        int batchSize = 10;
        int nbMigratedPagesVersions = 0;
        ArrayList<PageVersion> pagesVersionsInError = new ArrayList<PageVersion>();
        try {
            List pagesVersionsToMigrate;
            this.entityManagerService.startRequest(ExoContainerContext.getCurrentContainer());
            Long nbPagesVersionsToMigrate = this.pageVersionDAO.countPagesVersionsBySyntax(Syntax.XWIKI_2_0.toIdString());
            if (nbPagesVersionsToMigrate == null || nbPagesVersionsToMigrate == 0L) {
                LOG.info((Object)"Wiki pages versions syntax migration - No Wiki page version to migrate from XWiki syntax to HTML");
                return;
            }
            LOG.info((Object)"==== Starting Wiki pages versions syntax migration");
            LOG.info((Object)("Wiki pages versions syntax migration - Number of pages versions = " + nbPagesVersionsToMigrate));
            do {
                this.entityManagerService.endRequest(ExoContainerContext.getCurrentContainer());
                this.entityManagerService.startRequest(ExoContainerContext.getCurrentContainer());
                pagesVersionsToMigrate = this.pageVersionDAO.findAllVersionsBySyntax(Syntax.XWIKI_2_0.toIdString(), 0, batchSize);
                for (PageVersionEntity pageVersionEntity : pagesVersionsToMigrate) {
                    try {
                        LOG.info((Object)("Convert wiki page version " + pageVersionEntity.getId() + " to HTML"));
                        String markup = this.convertContent(pageVersionEntity.getContent());
                        pageVersionEntity.setContent(markup);
                        pageVersionEntity.setSyntax(Syntax.XHTML_1_0.toIdString());
                        this.pageVersionDAO.update((Object)pageVersionEntity);
                        ++nbMigratedPagesVersions;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while migrating wiki page version " + (pageVersionEntity != null ? Long.valueOf(pageVersionEntity.getId()) : "") + " to HTML"), (Throwable)e);
                        pagesVersionsInError.add(EntityConverter.convertPageVersionEntityToPageVersion((PageVersionEntity)pageVersionEntity));
                        pageVersionEntity.setSyntax("ERROR");
                        this.pageVersionDAO.update((Object)pageVersionEntity);
                    }
                }
                LOG.info((Object)("Wiki pages versions syntax migration - Progress : " + nbMigratedPagesVersions + "/" + nbPagesVersionsToMigrate));
            } while (pagesVersionsToMigrate != null && pagesVersionsToMigrate.size() == batchSize);
            LOG.info((Object)("==== Wiki pages versions syntax migration - Migration finished - Number of migrated pages = " + nbMigratedPagesVersions + ", number of errors = " + pagesVersionsInError.size()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while migrating wiki pages versions fom XWiki syntax to HTML", (Throwable)e);
        }
        finally {
            this.entityManagerService.endRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateAllPagesTemplates() {
        int batchSize = 10;
        int nbMigratedTemplates = 0;
        ArrayList<Template> templatesInError = new ArrayList<Template>();
        Map<String, String> configuredTemplates = this.loadConfiguredTemplates();
        try {
            List templatesToMigrate;
            this.entityManagerService.startRequest(ExoContainerContext.getCurrentContainer());
            Long nbTemplatesToMigrate = this.templateDAO.countTemplatesBySyntax(Syntax.XWIKI_2_0.toIdString());
            if (nbTemplatesToMigrate == null || nbTemplatesToMigrate == 0L) {
                LOG.info((Object)"Wiki pages templates syntax migration - No Wiki page template to migrate from XWiki syntax to HTML");
                return;
            }
            LOG.info((Object)"==== Starting Wiki pages templates syntax migration");
            LOG.info((Object)("Wiki pages templates syntax migration - Number of pages templates = " + nbTemplatesToMigrate));
            do {
                this.entityManagerService.endRequest(ExoContainerContext.getCurrentContainer());
                this.entityManagerService.startRequest(ExoContainerContext.getCurrentContainer());
                templatesToMigrate = this.templateDAO.findAllBySyntax(Syntax.XWIKI_2_0.toIdString(), 0, batchSize);
                for (TemplateEntity templateEntity : templatesToMigrate) {
                    try {
                        LOG.info((Object)("Convert wiki page template " + templateEntity.getId() + " to HTML"));
                        String markup = configuredTemplates.get(templateEntity.getName());
                        if (markup == null) {
                            markup = this.convertContent(templateEntity.getContent());
                        }
                        templateEntity.setContent(markup);
                        templateEntity.setSyntax(Syntax.XHTML_1_0.toIdString());
                        this.templateDAO.update((Object)templateEntity);
                        ++nbMigratedTemplates;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while migrating wiki page template " + (templateEntity != null ? Long.valueOf(templateEntity.getId()) : "") + " to HTML"), (Throwable)e);
                        templatesInError.add(EntityConverter.convertTemplateEntityToTemplate((TemplateEntity)templateEntity));
                        templateEntity.setSyntax("ERROR");
                        this.templateDAO.update((Object)templateEntity);
                    }
                }
                LOG.info((Object)("Wiki pages templates syntax migration - Progress : " + nbMigratedTemplates + "/" + nbTemplatesToMigrate));
            } while (templatesToMigrate != null && templatesToMigrate.size() == batchSize);
            LOG.info((Object)("==== Wiki pages templates syntax migration - Migration finished - Number of migrated pages = " + nbMigratedTemplates + ", number of errors = " + templatesInError.size()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while migrating wiki pages versions fom XWiki syntax to HTML", (Throwable)e);
        }
        finally {
            this.entityManagerService.endRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    protected void setWikiContext(Page page) throws ComponentLookupException, ComponentRepositoryException {
        RenderingService renderingService = (RenderingService)ExoContainerContext.getService(RenderingService.class);
        Execution ec = renderingService.getExecution();
        if (ec.getContext() == null) {
            ec.setContext(new ExecutionContext());
        }
        WikiContext wikiContext = new WikiContext();
        wikiContext.setType(page.getWikiType());
        wikiContext.setOwner(page.getWikiOwner());
        wikiContext.setPageName(page.getName());
        wikiContext.setPageTitle(page.getTitle());
        String portalURL = page.getUrl();
        if (portalURL == null) {
            portalURL = PortalContainer.getInstance().getPortalContext().getContextPath();
            portalURL = "group".equals(page.getWikiType()) ? portalURL + "/g/" + page.getWikiOwner().replaceAll("/", ":") + "/" + page.getWikiOwner().substring(page.getWikiOwner().lastIndexOf("/") + 1) : portalURL + "/" + page.getWikiOwner();
        } else {
            int index = page.getUrl().lastIndexOf("/wiki/");
            if (index >= 0) {
                portalURL = page.getUrl().substring(0, index);
            }
        }
        wikiContext.setPortalURL(portalURL);
        wikiContext.setPortletURI("/wiki");
        wikiContext.setRestURI("/" + PortalContainer.getCurrentPortalContainerName() + "/" + PortalContainer.getCurrentRestContextName() + "/wiki/tree/children/");
        wikiContext.setSyntax(Syntax.XWIKI_2_0.toIdString());
        ec.getContext().setProperty("wikicontext", (Object)wikiContext);
    }

    private Map<String, String> loadConfiguredTemplates() {
        HashMap<String, String> templates = new HashMap<String, String>();
        HashMap<String, String> configuredTemplates = new HashMap<String, String>();
        configuredTemplates.put("Status_Meeting", "war:/conf/wiki/data/templates/Status_Meeting.tmpl");
        configuredTemplates.put("HOW-TO_Guide", "war:/conf/wiki/data/templates/HOW-TO_Guide.tmpl");
        configuredTemplates.put("Leave_Planning", "war:/conf/wiki/data/templates/Leave_Planning.tmpl");
        configuredTemplates.forEach((name, templatePath) -> {
            try {
                InputStream templateInputStream = this.configurationManager.getInputStream(templatePath);
                if (templateInputStream != null) {
                    String templateContent = IOUtils.toString((InputStream)templateInputStream);
                    templates.put((String)name, templateContent);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot load wiki page template " + name + " with path " + templatePath), (Throwable)e);
            }
        });
        return templates;
    }
}

