/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.portal.jdbc.migration.AbstractMigrationService;
import org.exoplatform.portal.jdbc.migration.AppReferencesMigrationService;
import org.exoplatform.portal.jdbc.migration.AppRegistryMigrationService;
import org.exoplatform.portal.jdbc.migration.MigrationContext;
import org.exoplatform.portal.jdbc.migration.MigrationFilter;
import org.exoplatform.portal.jdbc.migration.NavigationMigrationService;
import org.exoplatform.portal.jdbc.migration.PageMigrationService;
import org.exoplatform.portal.jdbc.migration.SiteMigrationService;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.filter.ExtensibleFilter;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.filter.FilterDefinition;
import org.exoplatform.web.filter.FilterDefinitionPlugin;
import org.picocontainer.Startable;

public class RDBMSMigrationManager
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(RDBMSMigrationManager.class);
    public static final String MIGRATION_SETTING_GLOBAL_KEY = "MIGRATION_SETTING_GLOBAL";
    private PortalContainer container;
    private SiteMigrationService siteMigrationService;
    private PageMigrationService pageMigrationService;
    private NavigationMigrationService navMigrationService;
    private AppRegistryMigrationService appMigrationService;
    private AppReferencesMigrationService appReferencesMigrationService;
    private SettingService settingService;
    private ExtensibleFilter extensibleFilter;

    public RDBMSMigrationManager(PortalContainer container, SiteMigrationService siteMigrationService, PageMigrationService pageMigrationService, NavigationMigrationService navMigrationService, AppRegistryMigrationService appMigrationService, AppReferencesMigrationService appReferencesMigrationService, ExtensibleFilter extensibleFilter, SettingService settingService) {
        this.container = container;
        this.siteMigrationService = siteMigrationService;
        this.pageMigrationService = pageMigrationService;
        this.navMigrationService = navMigrationService;
        this.appMigrationService = appMigrationService;
        this.appReferencesMigrationService = appReferencesMigrationService;
        this.settingService = settingService;
        this.extensibleFilter = extensibleFilter;
    }

    public void start() {
        if (!MigrationContext.isApplicationContentIdDone()) {
            this.migrateApplicationNames();
        }
        if (MigrationContext.isDone()) {
            LOG.info((Object)"Overall Portal JCR to RDBMS migration already finished, ignore it.");
            return;
        }
        this.installMigrationFilter();
        Runnable migrateTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Field field = null;
                ExoContainerContext.setCurrentContainer((ExoContainer)RDBMSMigrationManager.this.container);
                RequestLifeCycle.begin((ExoContainer)RDBMSMigrationManager.this.container);
                try {
                    field = SessionImpl.class.getDeclaredField("FORCE_USE_GET_NODES_LAZILY");
                    if (field != null) {
                        field.setAccessible(true);
                        field.set(null, true);
                    }
                    List<PortalKey> sitesToMigrate = RDBMSMigrationManager.this.siteMigrationService.getSitesToMigrate();
                    RDBMSMigrationManager.this.migrateAppRegistry();
                    Set failedSitesToMigrate = RDBMSMigrationManager.this.migratePortals();
                    RDBMSMigrationManager.this.removeAppRegistry();
                    Set failedSitesToRemove = RDBMSMigrationManager.this.removePortals();
                    RDBMSMigrationManager.this.setMigrationAsDone(failedSitesToMigrate, failedSitesToRemove);
                    LOG.info("END PORTAL Migration for {} sites, failed sites to migrate = {}, failed sites to cleanup = {}, app registry : migrated = {}, cleaned up = {}. Overall migration finished successfully= {}", new Object[]{sitesToMigrate.size(), failedSitesToMigrate.isEmpty() ? "'0 sites'" : failedSitesToMigrate, failedSitesToRemove.isEmpty() ? "'0 sites'" : failedSitesToRemove, MigrationContext.isAppDone(), MigrationContext.isAppCleanupDone(), MigrationContext.isDone()});
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to run Portal Migration data from JCR to RDBMS", (Throwable)e);
                }
                finally {
                    RequestLifeCycle.end();
                    if (field != null) {
                        try {
                            field.set(null, false);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        };
        Thread migrationThread = new Thread(migrateTask);
        migrationThread.setPriority(5);
        migrationThread.setName("PORTAL-MIGRATION-RDBMS");
        migrationThread.start();
    }

    public void stop() {
        MigrationContext.setForceStop();
    }

    private void migrateApplicationNames() {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.appReferencesMigrationService.doMigration();
            MigrationContext.setApplicationContentIdDone();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while migrating application names", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void installMigrationFilter() {
        InitParams params = new InitParams();
        ObjectParameter objectParameter = new ObjectParameter();
        objectParameter.setName("filter");
        FilterDefinition filterDefinition = new FilterDefinition((Filter)new MigrationFilter(), Collections.singletonList("/.*"));
        objectParameter.setObject((Object)filterDefinition);
        params.addParameter((Parameter)objectParameter);
        this.extensibleFilter.addFilterDefinitions(new FilterDefinitionPlugin(params));
    }

    private void setMigrationAsDone(Set<PortalKey> failedSitesToMigrate, Set<PortalKey> failedSitesToRemove) {
        if (MigrationContext.isAppCleanupDone() && failedSitesToMigrate.isEmpty() && failedSitesToRemove.isEmpty()) {
            this.settingService.remove(MigrationContext.CONTEXT);
            MigrationContext.restartTransaction();
            MigrationContext.setDone();
            MigrationContext.restartTransaction();
            this.migrateApplicationNames();
            MigrationContext.restartTransaction();
        }
    }

    private Set<PortalKey> removePortals() {
        HashSet<PortalKey> failedSitesToRemove = new HashSet<PortalKey>();
        long startTime = System.currentTimeMillis();
        LOG.info((Object)"START CLEANUP PORTAL DATA ---------------------------------------------------");
        this.doRemove(failedSitesToRemove);
        LOG.info("END PORTAL DATA CLEANUP in {}ms-----------------------------------------------------", new Object[]{System.currentTimeMillis() - startTime});
        return failedSitesToRemove;
    }

    private void removeAppRegistry() {
        if (MigrationContext.isAppDone() && !MigrationContext.isAppCleanupDone()) {
            this.appMigrationService.doRemove();
            MigrationContext.restartTransaction();
        }
    }

    private Set<PortalKey> migratePortals() {
        HashSet<PortalKey> failedSitesToMigrate = new HashSet<PortalKey>();
        long startTime = System.currentTimeMillis();
        LOG.info((Object)"START ASYNC PORTAL DATA MIGRATION---------------------------------------------------");
        this.doMigrate(failedSitesToMigrate);
        LOG.info("END PORTAL DATA MIGRATION in {}ms-----------------------------------------------------", new Object[]{System.currentTimeMillis() - startTime});
        return failedSitesToMigrate;
    }

    private void migrateAppRegistry() {
        if (MigrationContext.isAppDone()) {
            LOG.info((Object)"APPLICATION REGISTRY migration already finished, ignore it.");
        } else {
            this.appMigrationService.doMigration();
            MigrationContext.restartTransaction();
        }
    }

    private void doMigrate(Set<PortalKey> failedSitesToMigrate) {
        int totalSitesToMigrateCount = MigrationContext.getSitesCountToMigrate();
        for (int siteToMigrateIndex = 0; siteToMigrateIndex < totalSitesToMigrateCount; ++siteToMigrateIndex) {
            if (MigrationContext.isForceStop()) {
                LOG.info("|  \\ FORCE STOPPING MIGRATION. Migrated {} / {} sites, failed = {}", new Object[]{siteToMigrateIndex, totalSitesToMigrateCount, failedSitesToMigrate.size()});
                return;
            }
            PortalKey siteToMigrateKey = MigrationContext.getNextSiteKeyToMigrate();
            boolean migrated = this.doMigrate(this.siteMigrationService, siteToMigrateKey, MigrationContext.PortalEntityType.SITE, siteToMigrateIndex, totalSitesToMigrateCount, failedSitesToMigrate);
            if (!migrated || MigrationContext.isForceStop() || !(migrated = this.doMigrate(this.pageMigrationService, siteToMigrateKey, MigrationContext.PortalEntityType.PAGE, siteToMigrateIndex, totalSitesToMigrateCount, failedSitesToMigrate)) || MigrationContext.isForceStop()) continue;
            this.doMigrate(this.navMigrationService, siteToMigrateKey, MigrationContext.PortalEntityType.NAVIGATION, siteToMigrateIndex, totalSitesToMigrateCount, failedSitesToMigrate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doMigrate(AbstractMigrationService migrationService, PortalKey siteToMigrateKey, MigrationContext.PortalEntityType entityType, int siteToMigrateIndex, int totalSitesToMigrateCount, Set<PortalKey> failedSitesToMigrate) {
        boolean migrated = true;
        long t1 = System.currentTimeMillis();
        if (MigrationContext.isMigrated(siteToMigrateKey, entityType)) {
            LOG.info("|  ---- \\ IGNORE::ALREADY migrated {} {} / {} (site: {}::{})", new Object[]{entityType.getTitle(), siteToMigrateIndex, totalSitesToMigrateCount, siteToMigrateKey.getType(), siteToMigrateKey.getId()});
        } else {
            LOG.info("|  ---- \\ START::migrate {} {} / {} (site: {}::{})", new Object[]{entityType.getTitle(), siteToMigrateIndex, totalSitesToMigrateCount, siteToMigrateKey.getType(), siteToMigrateKey.getId()});
            try {
                migrationService.doMigrate(siteToMigrateKey);
                MigrationContext.setMigrated(siteToMigrateKey, entityType);
                LOG.info("|  ---- / END::migrate {} {} / {} (site: {}::{}) in {}ms", new Object[]{entityType.getTitle(), siteToMigrateIndex, totalSitesToMigrateCount, siteToMigrateKey.getType(), siteToMigrateKey.getId(), System.currentTimeMillis() - t1});
            }
            catch (Exception e) {
                migrated = false;
                failedSitesToMigrate.add(siteToMigrateKey);
                LOG.error("|  ---- / END::migrate {} {} / {} (site: {}::{}) in {}ms", new Object[]{entityType.getTitle(), siteToMigrateIndex, totalSitesToMigrateCount, siteToMigrateKey.getType(), siteToMigrateKey.getId(), System.currentTimeMillis() - t1, e});
            }
            finally {
                MigrationContext.restartTransaction();
            }
        }
        return migrated;
    }

    private void doRemove(Set<PortalKey> failedSitesToRemove) {
        List<PortalKey> sitesToMigrate = this.siteMigrationService.getSitesToMigrate();
        int totalSitesToCleanupCount = sitesToMigrate.size();
        int siteToCleanupIndex = 0;
        for (PortalKey siteToCleanupKey : sitesToMigrate) {
            if (MigrationContext.isForceStop()) {
                LOG.info("|  \\ FORCE STOPPING CLEANUP. Cleaned up {} / {} sites, failed = {}", new Object[]{siteToCleanupIndex, totalSitesToCleanupCount, failedSitesToRemove.size()});
                return;
            }
            ++siteToCleanupIndex;
            if (!MigrationContext.isMigrated(siteToCleanupKey)) {
                LOG.info("|  ---- \\ IGNORE::NOT migrated yet site {} / {} (site: {}::{})", new Object[]{siteToCleanupIndex, totalSitesToCleanupCount, siteToCleanupKey.getType(), siteToCleanupKey.getId()});
                continue;
            }
            boolean removed = this.doRemove(this.navMigrationService, siteToCleanupKey, MigrationContext.PortalEntityType.NAVIGATION, siteToCleanupIndex, totalSitesToCleanupCount, failedSitesToRemove);
            if (!removed || MigrationContext.isForceStop() || !(removed = this.doRemove(this.pageMigrationService, siteToCleanupKey, MigrationContext.PortalEntityType.PAGE, siteToCleanupIndex, totalSitesToCleanupCount, failedSitesToRemove)) || MigrationContext.isForceStop()) continue;
            this.doRemove(this.siteMigrationService, siteToCleanupKey, MigrationContext.PortalEntityType.SITE, siteToCleanupIndex, totalSitesToCleanupCount, failedSitesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRemove(AbstractMigrationService migrationService, PortalKey siteToCleanupKey, MigrationContext.PortalEntityType entityType, int siteToCleanupIndex, int totalSitesToCleanupCount, Set<PortalKey> failedSitesToCleanup) {
        boolean removed = false;
        long t1 = System.currentTimeMillis();
        if (MigrationContext.isMigrated(siteToCleanupKey)) {
            LOG.info("|  ---- \\ START::cleanup {} {} / {} (site: {}::{})", new Object[]{entityType.getTitle(), siteToCleanupIndex, totalSitesToCleanupCount, siteToCleanupKey.getType(), siteToCleanupKey.getId()});
            try {
                migrationService.doRemove(siteToCleanupKey);
                removed = true;
                LOG.info("|  ---- / END::cleanup {} {} / {} (site: {}::{}) in {}ms", new Object[]{entityType.getTitle(), siteToCleanupIndex, totalSitesToCleanupCount, siteToCleanupKey.getType(), siteToCleanupKey.getId(), System.currentTimeMillis() - t1});
            }
            catch (Exception e) {
                failedSitesToCleanup.add(siteToCleanupKey);
                LOG.error("|  ---- / END::cleanup {} {} / {} (site: {}::{}) in {}ms", new Object[]{entityType.getTitle(), siteToCleanupIndex, totalSitesToCleanupCount, siteToCleanupKey.getType(), siteToCleanupKey.getId(), System.currentTimeMillis() - t1, e});
            }
            finally {
                MigrationContext.restartTransaction();
            }
        } else {
            LOG.info("|  ---- \\ IGNORE::NOT migrated yet site {} / {} (site: {}::{})", new Object[]{siteToCleanupIndex, totalSitesToCleanupCount, siteToCleanupKey.getType(), siteToCleanupKey.getId()});
        }
        return removed;
    }
}

