/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.TaskExecutionDecorator;
import org.exoplatform.portal.pom.config.TaskExecutor;
import org.exoplatform.portal.pom.config.tasks.PortalConfigTask;
import org.exoplatform.portal.pom.config.tasks.SearchTask;
import org.exoplatform.portal.pom.data.PortalKey;

public class PortalNamesCache
extends TaskExecutionDecorator {
    public PortalNamesCache(TaskExecutor next) {
        super(next);
    }

    @Override
    public <V> V execute(POMSession session, POMTask<V> task) throws Exception {
        if (!session.isModified()) {
            if (task instanceof SearchTask.FindSiteKey) {
                SearchTask.FindSiteKey find = (SearchTask.FindSiteKey)task;
                List data = (List)session.getFromCache(find.getKey());
                if (data == null) {
                    V result = super.execute(session, task);
                    LazyPageList list = (LazyPageList)result;
                    session.putInCache(find.getKey(), Collections.unmodifiableList(new ArrayList(list.getAll())));
                    return result;
                }
                return (V)new LazyPageList((ListAccess)new ListAccessImpl(PortalKey.class, data), 10);
            }
            if (task instanceof PortalConfigTask.Save || task instanceof PortalConfigTask.Remove) {
                V result = super.execute(session, task);
                session.scheduleForEviction(SearchTask.FindSiteKey.PORTAL_KEY);
                session.scheduleForEviction(SearchTask.FindSiteKey.GROUP_KEY);
                return result;
            }
        }
        return super.execute(session, task);
    }
}

