/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.serialization.MarshalledObject;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.DataCache;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.pom.config.POMSession;

public class SimpleDataCache
extends DataCache {
    protected Map<MarshalledObject<SiteKey>, MarshalledObject<NavigationData>> navigations = new ConcurrentHashMap<MarshalledObject<SiteKey>, MarshalledObject<NavigationData>>();
    protected Map<MarshalledObject<String>, MarshalledObject<NodeData>> nodes = new ConcurrentHashMap<MarshalledObject<String>, MarshalledObject<NodeData>>();

    @Override
    protected void removeNodes(Collection<String> keys) {
        for (String key : keys) {
            this.nodes.remove(MarshalledObject.marshall((Serializable)((Object)key)));
        }
    }

    @Override
    protected NodeData getNode(POMSession session, String key) {
        MarshalledObject marshalledKey = MarshalledObject.marshall((Serializable)((Object)key));
        MarshalledObject<NodeData> marshalledNode = this.nodes.get(marshalledKey);
        if (marshalledNode == null) {
            NodeData node = this.loadNode(session, key);
            if (node != null) {
                this.nodes.put((MarshalledObject<String>)marshalledKey, (MarshalledObject<NodeData>)MarshalledObject.marshall((Serializable)node));
                return node;
            }
            return null;
        }
        return (NodeData)marshalledNode.unmarshall();
    }

    @Override
    protected void removeNavigation(SiteKey key) {
        this.navigations.remove(MarshalledObject.marshall((Serializable)key));
    }

    @Override
    protected NavigationData getNavigation(POMSession session, SiteKey key) {
        MarshalledObject marshalledKey = MarshalledObject.marshall((Serializable)key);
        MarshalledObject<NavigationData> marshalledNavigation = this.navigations.get(marshalledKey);
        if (marshalledNavigation == null) {
            NavigationData navigation = this.loadNavigation(session, key);
            if (navigation != null) {
                this.navigations.put((MarshalledObject<SiteKey>)marshalledKey, (MarshalledObject<NavigationData>)MarshalledObject.marshall((Serializable)navigation));
                return navigation;
            }
            return null;
        }
        return (NavigationData)marshalledNavigation.unmarshall();
    }

    @Override
    protected void clear() {
        this.navigations.clear();
        this.nodes.clear();
    }
}

