/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.Utils;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.api.introspection.AnnotationIntrospector;
import org.reflext.api.introspection.AnnotationTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInfo {
    BeanInfo parent;
    final ClassTypeInfo classType;
    final boolean declared;
    final Map<String, PropertyInfo<?, ?>> properties;
    final Map<String, PropertyInfo<?, ?>> unmodifiableProperties;

    public BeanInfo(ClassTypeInfo classType, boolean declared) {
        this.classType = classType;
        this.declared = declared;
        this.properties = new HashMap();
        this.unmodifiableProperties = Collections.unmodifiableMap(this.properties);
    }

    public BeanInfo getParent() {
        return this.parent;
    }

    public ClassTypeInfo getClassType() {
        return this.classType;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public PropertyInfo<?, ?> getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, PropertyInfo<?, ?>> getProperties() {
        return this.properties;
    }

    public Collection<? extends Annotation> getAnnotations(Class<? extends Annotation> ... annotationClassTypes) {
        ArrayList<Annotation> props = new ArrayList<Annotation>();
        for (Class<? extends Annotation> annotationClassType : annotationClassTypes) {
            Annotation annotation = this.getAnnotation(annotationClassType);
            if (annotation == null) continue;
            props.add(annotation);
        }
        return props;
    }

    public ClassTypeInfo resolveToClass(TypeInfo type) {
        return Utils.resolveToClassType(this.classType, type);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)((Annotation)this.getAnnotation(AnnotationType.get(annotationClass)));
    }

    public <A> A getAnnotation(AnnotationType<A, ?> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException();
        }
        AnnotationIntrospector introspector = new AnnotationIntrospector(annotationType);
        AnnotationTarget annotationTarget = introspector.resolve(this.classType);
        return (A)(annotationTarget != null ? annotationTarget.getAnnotation() : null);
    }

    public String toString() {
        return "BeanInfo[name=" + this.classType.getName() + "]";
    }
}

