/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PublishedNewsImagesPermissionsUpgradePlugin
extends UpgradeProductPlugin {
    public static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    public static final String[] READ_PERMISSIONS = new String[]{"read"};
    public static final String PLATFORM_USERS_GROUP_IDENTITY = "*:/platform/users";
    private static final Log LOG = ExoLogger.getLogger((String)PublishedNewsImagesPermissionsUpgradePlugin.class.getName());
    private static final Pattern IMAGE_SRC_PATTERN = Pattern.compile("src=\"/portal/rest/images/?(.+)?\"");
    private final RepositoryService repositoryService;
    private final SessionProviderService sessionProviderService;
    private int imageNewsUpdatedCount;
    private int newsCount;

    public PublishedNewsImagesPermissionsUpgradePlugin(InitParams initParams, RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String s, String s1) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start upgrade of published news images permission");
        try (SessionProvider sessionProvider = null;){
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            QueryManager qm = session.getWorkspace().getQueryManager();
            int limit = 10;
            int offset = 0;
            String stringQuery = "select * from exo:news WHERE publication:currentState = 'published' AND jcr:path LIKE '/Groups/spaces/%'";
            Query jcrQuery = qm.createQuery(stringQuery, "sql");
            boolean hasMoreElements = true;
            while (hasMoreElements) {
                ((QueryImpl)jcrQuery).setOffset((long)offset);
                ((QueryImpl)jcrQuery).setLimit((long)limit);
                NodeIterator nodeIterator = jcrQuery.execute().getNodes();
                if (nodeIterator == null) continue;
                while (nodeIterator.hasNext()) {
                    Node newsNode = nodeIterator.nextNode();
                    this.updateNewsImagesPermissions(newsNode, session);
                }
                if (nodeIterator.getSize() < (long)limit) {
                    hasMoreElements = false;
                    continue;
                }
                offset += limit;
            }
            LOG.info("End updating of '{}' images for '{}' published news . It took {} ms.", new Object[]{this.imageNewsUpdatedCount, this.newsCount, System.currentTimeMillis() - startupTime});
        }
    }

    private void updateNewsImagesPermissions(Node newsNode, Session session) throws RepositoryException {
        Matcher matcher = IMAGE_SRC_PATTERN.matcher(this.getStringProperty(newsNode, "exo:body"));
        int imagesCount = 0;
        while (matcher.find()) {
            boolean isPublicImage;
            String match = matcher.group(1);
            String imageUUID = match.substring(match.lastIndexOf("/") + 1);
            ExtendedNode image = (ExtendedNode)session.getNodeByUUID(imageUUID);
            if (image == null) continue;
            if (image.canAddMixin(EXO_PRIVILEGEABLE)) {
                image.addMixin(EXO_PRIVILEGEABLE);
            }
            if (isPublicImage = image.getACL().getPermissionEntries().stream().filter(accessControlEntry -> accessControlEntry.getIdentity().equals(PLATFORM_USERS_GROUP_IDENTITY)).toList().size() > 0) continue;
            image.setPermission(PLATFORM_USERS_GROUP_IDENTITY, READ_PERMISSIONS);
            image.save();
            ++imagesCount;
        }
        if (imagesCount > 0) {
            ++this.newsCount;
            this.imageNewsUpdatedCount += imagesCount;
        }
    }

    private String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }
}

