/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.targets;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.news.upgrade.targets.PublishedNewsDisplayedPropUpgrade$AjcClosure1;
import org.exoplatform.news.upgrade.targets.PublishedNewsDisplayedPropUpgrade$AjcClosure3;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.jpa.storage.entity.MetadataItemEntity;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;

public class PublishedNewsDisplayedPropUpgrade
extends UpgradeProductPlugin {
    public static final String INSERT_NEWS_TARGETS_METADATA_ITEMS_PROPS = "INSERT INTO SOC_METADATA_ITEMS_PROPERTIES(METADATA_ITEM_ID, NAME, VALUE) VALUES(:newsTargetsMetadataItemId, :displayedStatus, :displayed)";
    public static final String DELETE_NEWS_TARGETS_METADATA_ITEMS_PROPS = "DELETE FROM SOC_METADATA_ITEMS_PROPERTIES WHERE METADATA_ITEM_ID = :newsTargetsMetadataItemId AND (NAME = :stagedStatus OR NAME = :displayedStatus)";
    public static final String GET_NEWS_TARGET_METADATA_ITEMS = "SELECT * FROM SOC_METADATA_ITEMS WHERE METADATA_ID IN :newsTargetMetadatas";
    public static final String STAGED_STATUS = "staged";
    private static final Log LOG;
    private EntityManagerService entityManagerService;
    private NewsService newsService;
    private MetadataService metadataService;
    private int migratedPublishedNewsCount = 0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public PublishedNewsDisplayedPropUpgrade(InitParams initParams, EntityManagerService entityManagerService, NewsService newsService, MetadataService metadataService) {
        super(initParams);
        this.entityManagerService = entityManagerService;
        this.newsService = newsService;
        this.metadataService = metadataService;
    }

    public int getMigratedPublishedNewsCount() {
        return this.migratedPublishedNewsCount;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start published news migration");
        List<MetadataItemEntity> newsTargetsMetadataItems = this.getNewsTargetMetadataItems();
        int totalPublishedNewsCount = newsTargetsMetadataItems.size();
        LOG.info("Total number of published news to be migrated: {}", new Object[]{totalPublishedNewsCount});
        int notMigratedPublishedNewsCount = 0;
        int processedPublishedNewsCount = 0;
        for (List newsTargetsMetadataItemsChunk : ListUtils.partition(newsTargetsMetadataItems, (int)10)) {
            int notMigratedPublishedNewsCountByTransaction = this.manageNewsTargetsMetadataItemsProps(newsTargetsMetadataItemsChunk);
            int processedPublishedNewsCountByTransaction = newsTargetsMetadataItemsChunk.size();
            this.migratedPublishedNewsCount += processedPublishedNewsCountByTransaction - notMigratedPublishedNewsCountByTransaction;
            LOG.info("Published news migration progress: processed={}/{} succeeded={} error={}", new Object[]{processedPublishedNewsCount += processedPublishedNewsCountByTransaction, totalPublishedNewsCount, this.migratedPublishedNewsCount, notMigratedPublishedNewsCount += notMigratedPublishedNewsCountByTransaction});
        }
        if (notMigratedPublishedNewsCount != 0) {
            LOG.warn("End published news migration with some errors: total={} succeeded={} error={}. It tooks {} ms.The not migrated items will be processed again next startup.", new Object[]{totalPublishedNewsCount, this.migratedPublishedNewsCount, notMigratedPublishedNewsCount, System.currentTimeMillis() - startupTime});
            throw new IllegalStateException("Some news items wasn't executed successfully. It will be re-attempted next startup");
        }
        LOG.info("End published news successful migration: total={} succeeded={} error={}. It tooks {} ms.", new Object[]{totalPublishedNewsCount, this.migratedPublishedNewsCount, notMigratedPublishedNewsCount, System.currentTimeMillis() - startupTime});
    }

    @ExoTransactional
    public List<MetadataItemEntity> getNewsTargetMetadataItems() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        PublishedNewsDisplayedPropUpgrade$AjcClosure1 publishedNewsDisplayedPropUpgrade$AjcClosure1 = new PublishedNewsDisplayedPropUpgrade$AjcClosure1(objectArray);
        return (List)ExoTransactionalAspect.aspectOf().around(publishedNewsDisplayedPropUpgrade$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public int manageNewsTargetsMetadataItemsProps(List<MetadataItemEntity> newsTargetsMetadataItems) {
        List<MetadataItemEntity> list = newsTargetsMetadataItems;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), list);
        Object[] objectArray = new Object[]{this, list, joinPoint};
        PublishedNewsDisplayedPropUpgrade$AjcClosure3 publishedNewsDisplayedPropUpgrade$AjcClosure3 = new PublishedNewsDisplayedPropUpgrade$AjcClosure3(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(publishedNewsDisplayedPropUpgrade$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    static {
        PublishedNewsDisplayedPropUpgrade.ajc$preClinit();
        LOG = ExoLogger.getLogger((String)PublishedNewsDisplayedPropUpgrade.class.getName());
    }

    static /* synthetic */ List getNewsTargetMetadataItems_aroundBody0(PublishedNewsDisplayedPropUpgrade ajc$this, JoinPoint joinPoint) {
        List<Long> newsTargetMetadatas = ajc$this.metadataService.getMetadatas(NewsTargetingService.METADATA_TYPE.getName(), 0L).stream().map(Metadata::getId).toList();
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        Query getNewsTargetMetadataItemsQuery = entityManager.createNativeQuery(GET_NEWS_TARGET_METADATA_ITEMS, MetadataItemEntity.class);
        getNewsTargetMetadataItemsQuery.setParameter("newsTargetMetadatas", newsTargetMetadatas);
        return getNewsTargetMetadataItemsQuery.getResultList();
    }

    static /* synthetic */ int manageNewsTargetsMetadataItemsProps_aroundBody2(PublishedNewsDisplayedPropUpgrade ajc$this, List newsTargetsMetadataItems, JoinPoint joinPoint) {
        int notMigratedPublishedNewsCount = 0;
        for (MetadataItemEntity newsTargetsMetadataItem : newsTargetsMetadataItems) {
            EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
            try {
                Query deleteNewsTargetMetadataItemsPropsQuery = entityManager.createNativeQuery(DELETE_NEWS_TARGETS_METADATA_ITEMS_PROPS, MetadataItemEntity.class);
                deleteNewsTargetMetadataItemsPropsQuery.setParameter("newsTargetsMetadataItemId", (Object)newsTargetsMetadataItem.getId());
                deleteNewsTargetMetadataItemsPropsQuery.setParameter("stagedStatus", (Object)STAGED_STATUS);
                deleteNewsTargetMetadataItemsPropsQuery.setParameter("displayedStatus", (Object)"displayed");
                deleteNewsTargetMetadataItemsPropsQuery.executeUpdate();
                News news = ajc$this.newsService.getNewsById(newsTargetsMetadataItem.getObjectId(), false);
                boolean displayed = !news.isArchived() && !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)STAGED_STATUS);
                Query insertNewsTargetMetadataItemsPropQuery = entityManager.createNativeQuery(INSERT_NEWS_TARGETS_METADATA_ITEMS_PROPS, MetadataItemEntity.class);
                insertNewsTargetMetadataItemsPropQuery.setParameter("newsTargetsMetadataItemId", (Object)newsTargetsMetadataItem.getId());
                insertNewsTargetMetadataItemsPropQuery.setParameter("displayedStatus", (Object)"displayed");
                insertNewsTargetMetadataItemsPropQuery.setParameter("displayed", (Object)String.valueOf(displayed));
                insertNewsTargetMetadataItemsPropQuery.executeUpdate();
            }
            catch (Exception e) {
                LOG.warn("Error migrating metadata item with id {}. Continue to migrate other items", new Object[]{newsTargetsMetadataItem.getId(), e});
                ++notMigratedPublishedNewsCount;
            }
        }
        return notMigratedPublishedNewsCount;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PublishedNewsDisplayedPropUpgrade.java", PublishedNewsDisplayedPropUpgrade.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewsTargetMetadataItems", "org.exoplatform.news.upgrade.targets.PublishedNewsDisplayedPropUpgrade", "", "", "", "java.util.List"), 126);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "manageNewsTargetsMetadataItemsProps", "org.exoplatform.news.upgrade.targets.PublishedNewsDisplayedPropUpgrade", "java.util.List", "newsTargetsMetadataItems", "", "int"), 140);
    }
}

