/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.templates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Workspace;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateServiceImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTypeTemplateUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)NodeTypeTemplateUpgradePlugin.class.getName());
    private static final String PRODUCT_VERSION_ZERO = "0";
    private static final String EDITED_CONFIGURED_NODE_TYPES = "EditedConfiguredNodeTypes";
    private static final String UNCHANG_NODE_TYPES_CONFIG = "exo.ecms.upgrades.unchanged-nodetype-templates";
    private TemplateService templateService_;
    private ProductInformations productInformations_;

    public NodeTypeTemplateUpgradePlugin(TemplateService templateService, ProductInformations productInformations, InitParams initParams) {
        super(initParams);
        this.templateService_ = templateService;
        this.productInformations_ = productInformations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        Set modifiedTemplateLog;
        String previousPlfVersion;
        String unchangedNodeTypes;
        block23: {
            block22: {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
                }
                unchangedNodeTypes = PrivilegedSystemHelper.getProperty((String)UNCHANG_NODE_TYPES_CONFIG);
                previousPlfVersion = PRODUCT_VERSION_ZERO;
                modifiedTemplateLog = new HashSet();
                try {
                    modifiedTemplateLog = Utils.getAllEditedConfiguredData((String)TemplateServiceImpl.class.getSimpleName(), (String)EDITED_CONFIGURED_NODE_TYPES, (boolean)true);
                }
                catch (Exception e1) {
                    if (!log.isErrorEnabled()) break block22;
                    log.error((Object)"Can not get All Edited Template log", (Throwable)e1);
                }
            }
            try {
                previousPlfVersion = this.productInformations_.getPreviousVersion();
            }
            catch (MissingProductInformationException e2) {
                if (!log.isErrorEnabled()) break block23;
                log.error((Object)"Can not get PLF previous version, set it to '0'", (Throwable)e2);
            }
        }
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedNodeTypes)) {
            unchangedNodeTypes = "";
        }
        try {
            HashSet<String> unchangedNodeTypeSet = new HashSet<String>();
            Set configuredNodeTypeSet = this.templateService_.getAllConfiguredNodeTypes();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedNodeType : unchangedNodeTypes.split(",")) {
                unchangedNodeTypeSet.add(unchangedNodeType.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Node templateHomeNode = this.templateService_.getTemplatesHome(sessionProvider);
            Workspace workspace = templateHomeNode.getSession().getWorkspace();
            NodeIterator iter = templateHomeNode.getNodes();
            while (iter.hasNext()) {
                Node templateNode = iter.nextNode();
                if (!configuredNodeTypeSet.contains(templateNode.getName()) || unchangedNodeTypeSet.contains(templateNode.getName())) continue;
                removedNodes.add(templateNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    String removedTemplateName = removedNode.getName();
                    if (!modifiedTemplateLog.contains(removedTemplateName)) {
                        if (log.isInfoEnabled()) {
                            log.info("Update templates of node type {} with a new version", new Object[]{removedTemplateName});
                        }
                        removedNode.remove();
                    } else {
                        if (log.isWarnEnabled()) {
                            StringBuffer logContent = new StringBuffer();
                            logContent.append("Templates of {} have been customized. ");
                            logContent.append("They will be updated by the new version included in eXo Platform ").append(this.productInformations_.getVersion());
                            logContent.append(" but your customized templates will be kept and renamed. ");
                            logContent.append("If you want to re-apply your customizations to the new templates versions, ");
                            logContent.append("you can retrieve them in the Content Administration.");
                            log.warn(logContent.toString(), new Object[]{removedTemplateName});
                        }
                        this.renameTemplate(removedNode, previousPlfVersion, workspace);
                    }
                    templateHomeNode.save();
                    this.removeTemplateFromEditLog(removedTemplateName);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Error in " + this.getName() + ": Can not remove old template: " + removedNode.getPath()), (Throwable)e);
                }
            }
            ((TemplateServiceImpl)this.templateService_).start();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"An unexpected error occurs when migrating node type template", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private void removeTemplateFromEditLog(String templateName) {
        block2: {
            try {
                Utils.removeEditedConfiguredData((String)templateName, (String)TemplateServiceImpl.class.getSimpleName(), (String)EDITED_CONFIGURED_NODE_TYPES, (boolean)true);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("Can not remove edited log of template {}", new Object[]{templateName});
            }
        }
    }

    private void renameTemplate(Node templateNode, String plfVersion, Workspace workspace) {
        String[] childNodesName;
        for (String nodeName : childNodesName = new String[]{"dialogs", "views", "skins"}) {
            try {
                if (!templateNode.hasNode(nodeName)) continue;
                Node childNode = templateNode.getNode(nodeName);
                if (log.isInfoEnabled()) {
                    log.info("Process rename children of {}", new Object[]{nodeName});
                }
                NodeIterator iter = childNode.getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    StringBuffer path = new StringBuffer(node.getPath());
                    workspace.move(path.toString(), path.append("_").append(plfVersion).toString());
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error("Exceptions happen while renaming children of {}", new Object[]{nodeName, e});
            }
        }
    }
}

