/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class PublishedNewsImagesPermissionsV2UpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)PublishedNewsImagesPermissionsV2UpgradePlugin.class.getName());
    private static final String IMAGE_SRC_REGEX = "src=\"/portal/rest/images/?(.+)?\"";
    private final RepositoryService repositoryService;
    private final SessionProviderService sessionProviderService;
    private final SpaceService spaceService;
    private int imageNewsUpdatedCount;
    private int newsCount;

    public PublishedNewsImagesPermissionsV2UpgradePlugin(InitParams initParams, RepositoryService repositoryService, SessionProviderService sessionProviderService, SpaceService spaceService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.spaceService = spaceService;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String s, String s1) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start upgrade of published news images permission");
        try (SessionProvider sessionProvider = null;){
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            QueryManager qm = session.getWorkspace().getQueryManager();
            int limit = 10;
            int offset = 0;
            String stringQuery = "select * from exo:news WHERE publication:currentState = 'published' AND jcr:path LIKE '/Groups/spaces/%'";
            Query jcrQuery = qm.createQuery(stringQuery, "sql");
            boolean hasMoreElements = true;
            while (hasMoreElements) {
                ((QueryImpl)jcrQuery).setOffset((long)offset);
                ((QueryImpl)jcrQuery).setLimit((long)limit);
                NodeIterator nodeIterator = jcrQuery.execute().getNodes();
                if (nodeIterator == null) continue;
                while (nodeIterator.hasNext()) {
                    Node newsNode = nodeIterator.nextNode();
                    this.updateNewsImagesPermissions(newsNode, session);
                }
                if (nodeIterator.getSize() < (long)limit) {
                    hasMoreElements = false;
                    continue;
                }
                offset += limit;
            }
            LOG.info("End updating of '{}' images for '{}' published news . It took {} ms.", new Object[]{this.imageNewsUpdatedCount, this.newsCount, System.currentTimeMillis() - startupTime});
        }
    }

    private void updateNewsImagesPermissions(Node newsNode, Session session) throws RepositoryException {
        Matcher matcher = Pattern.compile(IMAGE_SRC_REGEX).matcher(this.getStringProperty(newsNode, "exo:body"));
        int imagesCount = 0;
        ExtendedNode image = null;
        while (matcher.find()) {
            String match = matcher.group(1);
            String imageUUID = match.substring(match.lastIndexOf("/") + 1);
            image = (ExtendedNode)session.getNodeByUUID(imageUUID);
            imagesCount = this.updateNodePermissions(newsNode, image, imagesCount);
        }
        String existingUploadImagesSrcRegex = "src=\"" + CommonsUtils.getCurrentDomain() + "/" + PortalContainer.getCurrentPortalContainerName() + "/" + CommonsUtils.getRestContextName() + "/jcr/?(.+)?\"";
        matcher = Pattern.compile(existingUploadImagesSrcRegex).matcher(this.getStringProperty(newsNode, "exo:body"));
        while (matcher.find()) {
            String match = matcher.group(1);
            String imagePath = match.substring(match.indexOf("/Groups"));
            image = (ExtendedNode)this.getNodeByPath(imagePath, session);
            imagesCount = this.updateNodePermissions(newsNode, image, imagesCount);
        }
        if (imagesCount > 0) {
            ++this.newsCount;
            this.imageNewsUpdatedCount += imagesCount;
        }
    }

    private int updateNodePermissions(Node newsNode, ExtendedNode image, int imagesCount) throws RepositoryException {
        if (image != null) {
            boolean isPublicImage;
            String spaceId;
            Space space;
            if (image.canAddMixin("exo:privilegeable")) {
                image.addMixin("exo:privilegeable");
            }
            if ((space = this.spaceService.getSpaceById(spaceId = this.getStringProperty(newsNode, "exo:spaceId"))) != null) {
                image.setPermission("*:" + space.getGroupId(), new String[]{"read"});
                image.save();
            }
            if (this.getStringProperty(newsNode, "exo:audience").equals("all") && !(isPublicImage = image.getACL().getPermissionEntries().stream().anyMatch(accessControlEntry -> accessControlEntry.getIdentity().equals("any")))) {
                image.setPermission("any", new String[]{"read"});
                image.save();
                ++imagesCount;
            }
        }
        return imagesCount;
    }

    private String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }

    private Node getNodeByPath(String path, Session session) {
        try {
            return (Node)session.getItem(URLDecoder.decode(path, StandardCharsets.UTF_8));
        }
        catch (RepositoryException exception) {
            return null;
        }
    }
}

