/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.upgrade.notification;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotificationSettingsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(NotificationSettingsUpgradePlugin.class);
    private static final String NOTIFICATION_PLUGIN = "notification.upgrade.settings.plugin.types";
    private SettingService settingService;
    private UserSettingService userSettingService;
    private PluginSettingService pluginSettingService;
    private EntityManagerService entityManagerService;
    private String notificationPluginTypes;

    public NotificationSettingsUpgradePlugin(SettingService settingService, UserSettingService userSettingService, PluginSettingService pluginSettingService, EntityManagerService entityManagerService, InitParams initParams) {
        super(settingService, initParams);
        this.settingService = settingService;
        this.userSettingService = userSettingService;
        this.pluginSettingService = pluginSettingService;
        this.entityManagerService = entityManagerService;
        if (initParams.containsKey((Object)NOTIFICATION_PLUGIN)) {
            this.notificationPluginTypes = initParams.getValueParam(NOTIFICATION_PLUGIN).getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        List<String> pluginTypes = Arrays.asList(this.notificationPluginTypes.replace("\n", "").replaceAll("\\s", "").split(","));
        int pageSize = 20;
        int current = 0;
        try {
            List usersContexts;
            LOG.info((Object)"=== Start initialisation of settings");
            LOG.info((Object)"  Starting activating Notifications for users");
            this.entityManagerService.startRequest(currentContainer);
            long startTime = System.currentTimeMillis();
            do {
                LOG.info("  Progression of users Notifications settings initialisation : {} users", new Object[]{current});
                usersContexts = this.settingService.getContextNamesByType(Context.USER.getName(), current, pageSize);
                if (usersContexts == null) continue;
                for (String userName : usersContexts) {
                    long startUserTime = System.currentTimeMillis();
                    try {
                        this.entityManagerService.endRequest(currentContainer);
                        this.entityManagerService.startRequest(currentContainer);
                        UserSetting userSetting = this.userSettingService.get(userName);
                        if (userSetting != null) {
                            for (String pluginType : pluginTypes) {
                                PluginInfo pluginTypeConfig = this.findPlugin(pluginType);
                                if (pluginTypeConfig == null) {
                                    LOG.info("=== couldn't initialize the settings of {} , plugin is not found", new Object[]{pluginType});
                                    continue;
                                }
                                this.updateSetting(userSetting, pluginTypeConfig);
                            }
                            this.userSettingService.save(userSetting);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Error while activating {} Notifications for user {} ", new Object[]{userName, e});
                    }
                    LOG.info("Time to treat user={} : {}ms", new Object[]{userName, System.currentTimeMillis() - startUserTime});
                }
                current += usersContexts.size();
            } while (usersContexts != null && !usersContexts.isEmpty());
            long endTime = System.currentTimeMillis();
            LOG.info("  Users Notifications settings initialised in {} ms", new Object[]{endTime - startTime});
        }
        catch (Exception e) {
            LOG.error("Error while initialisation of users Notifications settings - Cause :", new Object[]{e.getMessage(), e});
        }
        finally {
            this.entityManagerService.endRequest(currentContainer);
        }
        LOG.info("=== {} users with modified notifications settings have been found and processed successfully", new Object[]{current});
        LOG.info((Object)"=== End initialisation of Notifications settings");
    }

    private PluginInfo findPlugin(String type) {
        for (PluginInfo plugin : this.pluginSettingService.getAllPlugins()) {
            if (!plugin.getType().equals(type)) continue;
            return plugin;
        }
        return null;
    }

    private void updateSetting(UserSetting userSetting, PluginInfo config) {
        for (String defaultConf : config.getDefaultConfig()) {
            for (String channelId : userSetting.getChannelActives()) {
                if (UserSetting.FREQUENCY.getFrequecy((String)defaultConf) == UserSetting.FREQUENCY.INSTANTLY) {
                    userSetting.addChannelPlugin(channelId, config.getType());
                    continue;
                }
                userSetting.addPlugin(config.getType(), UserSetting.FREQUENCY.getFrequecy((String)defaultConf));
            }
        }
    }
}

