/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Arrays;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceApplicationMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceApplicationMigration.class);
    private SpaceService spaceService;
    private EntityManagerService entityManagerService;
    private SettingService settingService;
    private static final String OLD_APP_NAME = "old.app.name";
    private static final String OLD_APP_ID = "old.app.id";
    private static final String NEW_APP_ID = "new.app.id";
    private static final String SPACE_APPLICATION_MIGRATION_SETTING_KEY = "SpaceApplicationMigrationEnded";
    private String oldAppName;
    private String oldAppId;
    private String newAppId;
    private boolean oldSpaceAppRemoved = false;

    public SpaceApplicationMigration(SpaceService spaceService, EntityManagerService entityManagerService, SettingService settingService, InitParams initParams) {
        super(initParams);
        this.spaceService = spaceService;
        this.entityManagerService = entityManagerService;
        this.settingService = settingService;
        this.oldAppName = initParams.getValueParam(OLD_APP_NAME).getValue();
        this.oldAppId = initParams.getValueParam(OLD_APP_ID).getValue();
        this.newAppId = initParams.getValueParam(NEW_APP_ID).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String s, String s1) {
        LOG.info("Start upgrade of space application: {}", new Object[]{this.oldAppId});
        long startupTime = System.currentTimeMillis();
        PortalContainer container = PortalContainer.getInstance();
        RequestLifeCycle.begin((ExoContainer)container);
        int updatedSpaces = 0;
        try {
            SpaceFilter spaceFilter = new SpaceFilter();
            spaceFilter.setAppId(this.oldAppId);
            ListAccess spaces = this.spaceService.getAllSpacesByFilter(spaceFilter);
            Space[] loadedSpaces = (Space[])spaces.load(0, spaces.getSize());
            updatedSpaces = loadedSpaces.length;
            Arrays.stream(loadedSpaces).forEach(space -> {
                try {
                    this.forceRemoveOldApplication((Space)space);
                    this.removeApp((Space)space, this.oldAppId, this.oldAppName);
                    if (!SpaceUtils.isInstalledApp((Space)space, (String)this.newAppId)) {
                        this.spaceService.installApplication(space, this.newAppId);
                    }
                    this.spaceService.activateApplication(space, this.newAppId);
                    LOG.info("Space application: {} of space: {} has been updated", new Object[]{this.newAppId, space.getDisplayName()});
                }
                catch (SpaceException e) {
                    LOG.error("Error while removing old space application: {} and installing new space application: {}", new Object[]{this.oldAppId, this.newAppId, e});
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error while getting spaces those contain the old space application {}", new Object[]{this.oldAppId, e});
        }
        finally {
            RequestLifeCycle.end();
        }
        LOG.info("End upgrade of space application: {}. {} spaces has been updated. It took {} ms", new Object[]{this.oldAppId, updatedSpaces, System.currentTimeMillis() - startupTime});
    }

    public void afterUpgrade() {
        this.settingService.set(Context.GLOBAL.id(this.oldAppId + ":" + this.newAppId), Scope.APPLICATION.id(this.oldAppId + ":" + this.newAppId), SPACE_APPLICATION_MIGRATION_SETTING_KEY, SettingValue.create((Boolean)true));
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL.id(this.oldAppId + ":" + this.newAppId), Scope.APPLICATION.id(this.oldAppId + ":" + this.newAppId), SPACE_APPLICATION_MIGRATION_SETTING_KEY);
        return settingValue == null || settingValue.getValue().equals("false");
    }

    private void forceRemoveOldApplication(Space space) {
        block5: {
            LOG.info("Remove old space application: {}", new Object[]{this.oldAppId});
            boolean transactionStarted = false;
            EntityManager entityManager = this.entityManagerService.getEntityManager();
            try {
                if (!entityManager.getTransaction().isActive()) {
                    entityManager.getTransaction().begin();
                    transactionStarted = true;
                }
                String sqlString = "DELETE FROM PORTAL_PAGES WHERE SITE_ID IN (SELECT ID FROM PORTAL_SITES WHERE NAME ='" + space.getGroupId() + "') AND NAME='" + this.oldAppId + "'";
                String sqlString1 = "DELETE FROM SOC_APPS WHERE APP_ID='" + this.oldAppId + "' AND SPACE_ID= '" + space.getId() + "'";
                Query nativeQuery = entityManager.createNativeQuery(sqlString);
                Query nativeQuery1 = entityManager.createNativeQuery(sqlString1);
                nativeQuery1.executeUpdate();
                nativeQuery.executeUpdate();
                if (this.oldSpaceAppRemoved) {
                    String sqlString2 = "DELETE FROM PORTAL_APPLICATIONS WHERE APP_NAME='" + this.oldAppId + "'";
                    Query nativeQuery2 = entityManager.createNativeQuery(sqlString2);
                    nativeQuery2.executeUpdate();
                    this.oldSpaceAppRemoved = true;
                }
                if (transactionStarted && entityManager.getTransaction().isActive()) {
                    entityManager.getTransaction().commit();
                }
            }
            catch (Exception e) {
                if (!transactionStarted || !entityManager.getTransaction().isActive() || !entityManager.getTransaction().getRollbackOnly()) break block5;
                entityManager.getTransaction().rollback();
            }
        }
        LOG.info("End remove old space application: {}", new Object[]{this.oldAppId});
    }

    private void removeApp(Space space, String appId, String appName) {
        String[] array = space.getApp().split(appId + ":+" + appName + ":(true|false):active,");
        Object newApp = array.length == 2 ? array[0] + array[1] : array[0];
        space.setApp((String)newApp);
        this.spaceService.updateSpace(space);
    }
}

