/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.HashSet;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.SpaceApplicationMigration;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
public class SpaceApplicationMigrationTest
extends AbstractKernelTest {
    protected PortalContainer container;
    protected SpaceService spaceService;
    protected NavigationService navigationService;
    protected IdentityRegistry identityRegistry;
    protected EntityManagerService entityManagerService;
    protected SettingService settingService;
    private SpaceApplicationMigration spaceApplicationMigration;

    public SpaceApplicationMigrationTest() {
        this.setForceContainerReload(true);
    }

    @Before
    public void setUp() {
        this.container = this.getContainer();
        this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        this.navigationService = (NavigationService)this.container.getComponentInstanceOfType(NavigationService.class);
        this.identityRegistry = (IdentityRegistry)this.container.getComponentInstanceOfType(IdentityRegistry.class);
        this.entityManagerService = (EntityManagerService)this.container.getComponentInstanceOfType(EntityManagerService.class);
        this.settingService = (SettingService)this.container.getComponentInstanceOfType(SettingService.class);
        RequestLifeCycle.begin((ExoContainer)this.container);
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        ValueParam oldAppNamevalueParam = new ValueParam();
        oldAppNamevalueParam.setName("old.app.name");
        oldAppNamevalueParam.setValue("Documents");
        ValueParam oldAppIdvalueParam = new ValueParam();
        oldAppIdvalueParam.setName("old.app.id");
        oldAppIdvalueParam.setValue("FileExplorerPortlet");
        ValueParam newAppIdvalueParam = new ValueParam();
        newAppIdvalueParam.setName("new.app.id");
        newAppIdvalueParam.setValue("Documents");
        initParams.addParameter((Parameter)valueParam);
        initParams.addParameter((Parameter)oldAppNamevalueParam);
        initParams.addParameter((Parameter)oldAppIdvalueParam);
        initParams.addParameter((Parameter)newAppIdvalueParam);
        this.spaceApplicationMigration = new SpaceApplicationMigration(this.spaceService, this.entityManagerService, this.settingService, initParams);
    }

    @After
    public void tearDown() throws Exception {
        RequestLifeCycle.end();
    }

    @Test
    public void processUpgrade() throws Exception {
        this.startAdminSession();
        Space space = new Space();
        space.setDisplayName("testspace");
        space.setPrettyName(space.getDisplayName());
        String shortName = SpaceUtils.cleanString((String)space.getDisplayName());
        space.setGroupId("/spaces/" + shortName);
        space.setUrl(shortName);
        space.setEditor("root");
        space.setRegistration("validation");
        space.setTemplate("classic");
        space.setVisibility("public");
        space.setPriority("2");
        String[] manager = new String[]{"root"};
        String[] members = new String[]{"root", "john"};
        space.setManagers(manager);
        space.setMembers(members);
        space = this.spaceService.createSpace(space, "root");
        SpaceApplicationMigrationTest.assertTrue((boolean)SpaceUtils.isInstalledApp((Space)space, (String)"FileExplorerPortlet"));
        this.spaceApplicationMigration.processUpgrade(null, null);
        space = this.spaceService.getSpaceById(space.getId());
        SpaceApplicationMigrationTest.assertFalse((boolean)SpaceUtils.isInstalledApp((Space)space, (String)"FileExplorerPortlet"));
        SpaceApplicationMigrationTest.assertTrue((boolean)SpaceUtils.isInstalledApp((Space)space, (String)"Documents"));
    }

    @Test
    public void afterUpgrade() {
        this.spaceApplicationMigration.afterUpgrade();
        SettingValue settingValue = this.settingService.get(Context.GLOBAL.id("FileExplorerPortlet:Documents"), Scope.APPLICATION.id("FileExplorerPortlet:Documents"), "SpaceApplicationMigrationEnded");
        SpaceApplicationMigrationTest.assertEquals((Object)true, (Object)settingValue.getValue());
    }

    private void startAdminSession() {
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/users", "*"));
        memberships.add(new MembershipEntry("/platform/administrators", "*"));
        Identity root = new Identity("root", memberships);
        this.identityRegistry.register(root);
        ConversationState conversationState = new ConversationState(root);
        ConversationState.setCurrent((ConversationState)conversationState);
    }
}

