/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.AddCSSClassToPage;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
@RunWith(value=MockitoJUnitRunner.class)
public class AddCSSClassToPageTest
extends AbstractKernelTest {
    private PageStorage pageStorage;

    @Before
    public void setUp() throws Exception {
        this.pageStorage = (PageStorage)Mockito.mock(PageStorage.class);
    }

    @Test
    public void processUpgrade() {
        InitParams initParams = new InitParams();
        ValueParam siteParam = new ValueParam();
        siteParam.setName("site-name");
        siteParam.setValue("dw");
        initParams.addParameter((Parameter)siteParam);
        ValueParam pageNameParam = new ValueParam();
        pageNameParam.setName("page-name");
        pageNameParam.setValue("homepage");
        initParams.addParameter((Parameter)pageNameParam);
        ValueParam containerIdParam = new ValueParam();
        containerIdParam.setName("container-id");
        containerIdParam.setValue("homePageContainer");
        initParams.addParameter((Parameter)containerIdParam);
        ValueParam cssClassesParam = new ValueParam();
        cssClassesParam.setName("css-classes");
        cssClassesParam.setValue("testClass firstClass");
        initParams.addParameter((Parameter)cssClassesParam);
        Page homePage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.pageStorage.getPage(new PageKey(SiteType.PORTAL.getName(), "dw", "homepage"))).thenReturn((Object)homePage);
        Container firstContainer = new Container();
        firstContainer.setId("homePageContainer");
        Container secondContainer = new Container();
        secondContainer.setId("footerContainer");
        Mockito.when((Object)homePage.getChildren()).thenReturn(new ArrayList<Container>(List.of(firstContainer, secondContainer)));
        AddCSSClassToPage addCSSClassToPage = new AddCSSClassToPage(this.pageStorage, initParams);
        addCSSClassToPage.processUpgrade("v1", "v2");
        ((PageStorage)Mockito.verify((Object)this.pageStorage, (VerificationMode)Mockito.times((int)1))).save(homePage.build());
        for (ModelObject c : homePage.getChildren()) {
            if (((Container)c).getId().equals("homePageContainer")) {
                AddCSSClassToPageTest.assertEquals((String)"testClass firstClass", (String)((Container)c).getCssClass());
                continue;
            }
            AddCSSClassToPageTest.assertNull((Object)((Container)c).getCssClass());
        }
    }
}

