/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.PortalPagesProfilesMigration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PortalPagesProfilesMigrationTest {
    @Mock
    private PortalContainer container;
    @Mock
    private EntityManagerService entityManagerService;
    @Mock
    private EntityManager entityManager;
    @Mock
    private EntityTransaction transaction;
    @Mock
    private Query query;
    private PortalPagesProfilesMigration portalPagesProfilesMigration;

    @Test
    public void testProcessUpgrade() {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("old.pages.profiles");
        valueParam.setValue("oldPagesProfiles");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.pages.profiles");
        valueParam.setValue("newPagesProfiles");
        initParams.addParameter((Parameter)valueParam);
        this.portalPagesProfilesMigration = new PortalPagesProfilesMigration(this.container, this.entityManagerService, initParams);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)this.entityManager);
        Mockito.when((Object)this.entityManager.getTransaction()).thenReturn((Object)this.transaction);
        Mockito.when((Object)this.transaction.isActive()).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)this.entityManager.createNativeQuery(ArgumentMatchers.anyString())).thenReturn((Object)this.query);
        Mockito.when((Object)this.query.executeUpdate()).thenReturn((Object)10);
        this.portalPagesProfilesMigration.processUpgrade("6.5", "7.0");
        String expectedQuery = "UPDATE PORTAL_PAGES  SET PROFILES = 'newPagesProfiles' WHERE PROFILES = 'oldPagesProfiles' AND ID > 0;";
        ((EntityTransaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.times((int)2))).isActive();
        ((EntityTransaction)Mockito.verify((Object)this.transaction)).begin();
        ((EntityManager)Mockito.verify((Object)this.entityManager, (VerificationMode)Mockito.times((int)1))).createNativeQuery(expectedQuery);
        ((Query)Mockito.verify((Object)this.query)).executeUpdate();
        ((EntityTransaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.times((int)1))).commit();
        ((EntityManager)Mockito.verify((Object)this.entityManager, (VerificationMode)Mockito.times((int)1))).flush();
        Assert.assertEquals((long)10L, (long)this.portalPagesProfilesMigration.getPagesUpdatedCount());
    }
}

