/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotesFolderPermissionsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(NotesFolderPermissionsUpgradePlugin.class);
    private final RepositoryService repositoryService;
    private final SessionProviderService sessionProviderService;
    private int notesCount;

    public NotesFolderPermissionsUpgradePlugin(InitParams initParams, RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String s, String s1) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start upgrade of space notes node permission");
        try (SessionProvider sessionProvider = null;){
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            QueryManager qm = session.getWorkspace().getQueryManager();
            int limit = 10;
            int offset = 0;
            String stringQuery = "select * from nt:folder WHERE jcr:path LIKE '/Groups/spaces/%/notes'";
            Query jcrQuery = qm.createQuery(stringQuery, "sql");
            boolean hasMoreElements = true;
            while (hasMoreElements) {
                ((QueryImpl)jcrQuery).setOffset((long)offset);
                ((QueryImpl)jcrQuery).setLimit((long)limit);
                NodeIterator nodeIterator = jcrQuery.execute().getNodes();
                if (nodeIterator == null) continue;
                while (nodeIterator.hasNext()) {
                    Node notesNode = nodeIterator.nextNode();
                    this.updateNotesNodePermissions(notesNode);
                }
                if (nodeIterator.getSize() < (long)limit) {
                    hasMoreElements = false;
                    continue;
                }
                offset += limit;
            }
            LOG.info("End updating of '{}' space notes node permissions. It took {} ms.", new Object[]{this.notesCount, System.currentTimeMillis() - startupTime});
        }
    }

    private void updateNotesNodePermissions(Node node) {
        block5: {
            try {
                boolean isWrongPermission;
                String nodePath = node.getPath();
                String groupId = nodePath.substring(nodePath.indexOf("/spaces/"), nodePath.indexOf("/notes"));
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                if (isWrongPermission = ((ExtendedNode)node).getACL().getPermissionEntries().stream().anyMatch(accessControlEntry -> accessControlEntry.getIdentity().equals(groupId))) {
                    ((ExtendedNode)node).removePermission(groupId);
                    ((ExtendedNode)node).setPermission("*:" + groupId, new String[]{"read", "add_node", "set_property"});
                    node.save();
                    ++this.notesCount;
                    NodeIterator nodeIterator = node.getNodes();
                    if (nodeIterator.hasNext()) {
                        this.updateNotesNodePermissions(nodeIterator.nextNode());
                    }
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)"An unexpected error occurs when updating notes jcr node permissions:", (Throwable)e);
            }
        }
    }
}

