/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade;

import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.wiki.upgrade.NotesFolderPermissionsUpgradePlugin;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NotesFolderPermissionsUpgradePluginTest {
    @Mock
    RepositoryService repositoryService;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    Session session;
    @Mock
    SessionProviderService sessionProviderService;
    @Mock
    SessionProvider sessionProvider;

    @Test
    public void NotesFolderPermissionsUpgradePluginTest() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.news");
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        QueryManager qm = (QueryManager)Mockito.mock(QueryManager.class);
        Workspace workSpace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workSpace);
        Mockito.when((Object)workSpace.getQueryManager()).thenReturn((Object)qm);
        Query query = (Query)Mockito.mock(QueryImpl.class);
        Mockito.when((Object)qm.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)query);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        ExtendedNode notesNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)notesNode.getPath()).thenReturn((Object)"Group/spaces/test/notes");
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)notesNode);
        AccessControlList accessControlList = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)notesNode.getACL()).thenReturn((Object)accessControlList);
        AccessControlEntry accessControlEntry = new AccessControlEntry("/spaces/test", "read");
        Mockito.when((Object)accessControlList.getPermissionEntries()).thenReturn(List.of(accessControlEntry));
        NodeIterator imagesNodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)notesNode.getNodes()).thenReturn((Object)imagesNodeIterator);
        Mockito.when((Object)imagesNodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        ExtendedNode imagesNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)imagesNodeIterator.nextNode()).thenReturn((Object)imagesNode);
        Mockito.when((Object)imagesNode.getPath()).thenReturn((Object)"Group/spaces/test/notes/images");
        Mockito.when((Object)imagesNode.getNodes()).thenReturn((Object)imagesNodeIterator);
        Mockito.when((Object)imagesNode.getACL()).thenReturn((Object)accessControlList);
        NotesFolderPermissionsUpgradePlugin notesFolderPermissionsUpgradePlugin = new NotesFolderPermissionsUpgradePlugin(initParams, this.repositoryService, this.sessionProviderService);
        notesFolderPermissionsUpgradePlugin.processUpgrade(null, null);
        ((ExtendedNode)Mockito.verify((Object)notesNode, (VerificationMode)Mockito.times((int)1))).removePermission("/spaces/test");
        ((ExtendedNode)Mockito.verify((Object)notesNode, (VerificationMode)Mockito.times((int)1))).setPermission("*:/spaces/test", new String[]{"read", "add_node", "set_property"});
        ((ExtendedNode)Mockito.verify((Object)notesNode, (VerificationMode)Mockito.times((int)1))).save();
        ((ExtendedNode)Mockito.verify((Object)imagesNode, (VerificationMode)Mockito.times((int)1))).removePermission("/spaces/test");
        ((ExtendedNode)Mockito.verify((Object)imagesNode, (VerificationMode)Mockito.times((int)1))).setPermission("*:/spaces/test", new String[]{"read", "add_node", "set_property"});
        ((ExtendedNode)Mockito.verify((Object)imagesNode, (VerificationMode)Mockito.times((int)1))).save();
        accessControlEntry = new AccessControlEntry("*:/spaces/test", "read");
        Mockito.when((Object)accessControlList.getPermissionEntries()).thenReturn(List.of(accessControlEntry));
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        notesFolderPermissionsUpgradePlugin.processUpgrade(null, null);
        ((ExtendedNode)Mockito.verify((Object)notesNode, (VerificationMode)Mockito.atLeast((int)0))).setPermission("*:/spaces/test", new String[]{"read", "add_node", "set_property"});
        ((ExtendedNode)Mockito.verify((Object)notesNode, (VerificationMode)Mockito.atLeast((int)0))).save();
    }
}

