/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade;

import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.upgrade.WikiPageNameUpgradePlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WikiPageNameUpgradePluginTest {
    protected PortalContainer container;
    protected WikiService wikiService;
    protected NoteService noteService;
    protected DataStorage dataStorage;
    protected EntityManagerService entityManagerService;
    private final String oldNoteName = "oldName";
    private final String newNoteName = "newName";
    private final String newTitle = "newTitle";
    private final String wikiType = "user";
    private final String currentUser = "user";

    @Before
    public void setUp() {
        this.container = PortalContainer.getInstance();
        this.wikiService = (WikiService)CommonsUtils.getService(WikiService.class);
        this.noteService = (NoteService)CommonsUtils.getService(NoteService.class);
        this.dataStorage = (DataStorage)CommonsUtils.getService(DataStorage.class);
        this.entityManagerService = (EntityManagerService)CommonsUtils.getService(EntityManagerService.class);
        this.begin();
    }

    @After
    public void tearDown() {
        this.end();
    }

    @Test
    public void testWikiMigration() throws WikiException {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("old.note.name");
        valueParam.setValue("oldName");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.note.name");
        valueParam.setValue("newName");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.note.title");
        valueParam.setValue("newTitle");
        initParams.addParameter((Parameter)valueParam);
        Identity identity = new Identity("user");
        ConversationState.setCurrent((ConversationState)new ConversationState(identity));
        Wiki gWiki = this.wikiService.createWiki("user", "user");
        List pages = this.noteService.getNotesOfWiki("user", "user");
        int initialWikiPages = pages.size();
        Assert.assertTrue((initialWikiPages > 0 ? 1 : 0) != 0);
        Page page = new Page();
        page.setTitle("oldName");
        page.setName("oldName");
        Page parentPage = this.noteService.getNoteOfNoteBookByName("user", "user", ((Page)pages.get(0)).getName());
        Assert.assertNotNull((Object)parentPage);
        this.noteService.createNote(gWiki, parentPage, page);
        page = this.wikiService.getPageOfWikiByName("user", "user", "oldName");
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)page.getName(), (Object)"oldName");
        WikiPageNameUpgradePlugin wikiPageNameUpgradePlugin = new WikiPageNameUpgradePlugin(this.container, this.entityManagerService, initParams);
        wikiPageNameUpgradePlugin.processUpgrade(null, null);
        page = this.wikiService.getPageOfWikiByName("user", "user", "oldName");
        Assert.assertNull((Object)page);
        page = this.wikiService.getPageOfWikiByName("user", "user", "newName");
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)page.getName(), (Object)"newName");
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }
}

