// Generated by delombok at Wed Apr 24 08:19:20 UTC 2019
package org.exoplatform.addon.ethereum.wallet.model;

import static org.exoplatform.addon.ethereum.wallet.utils.Utils.jsonArrayToList;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.*;
import lombok.EqualsAndHashCode.Exclude;

public class WalletPreferences implements Serializable {
  private static final String OVERVIEW_ACCOUNTS_PARAM = "overviewAccounts";
  private static final String PRINCIPAL_ACCOUNT_PARAM = "principalAccount";
  private static final String ENABLE_DELEGATION_PARAM = "enableDelegation";
  private static final String DATA_VERSION_PARAM = "dataVersion";
  private static final String PHRASE_PARAM = "phrase";
  private static final String WALLET_ADDRESS_PARAM = "walletAddress";
  private static final String DEFAULT_GAS_PARAM = "defaultGas";
  private static final String CURRENCY_PARAM = "currency";
  private static final String ADDRESSES_LABELS = "addresesLabels";
  private static final long serialVersionUID = -5725443183560646198L;
  private String walletAddress = null;
  private Integer dataVersion = 0;
  private Long defaultGas = 0L;
  private String currency = "usd";
  private String phrase = null;
  private String principalAccount = null;
  private Set<String> overviewAccounts;
  private Boolean enableDelegation = null;
  private Wallet wallet = null;
  private boolean hasKeyOnServerSide;
  private Set<AddressLabel> addresesLabels;

  public String toJSONString() {
    return toJSONObject().toString();
  }

  public JSONObject toJSONObject() {
    JSONObject jsonObject = new JSONObject();
    try {
      jsonObject.put(CURRENCY_PARAM, currency);
      jsonObject.put(DEFAULT_GAS_PARAM, defaultGas);
      jsonObject.put(WALLET_ADDRESS_PARAM, walletAddress);
      jsonObject.put(PHRASE_PARAM, phrase);
      jsonObject.put(DATA_VERSION_PARAM, dataVersion);
      if (enableDelegation != null) {
        jsonObject.put(ENABLE_DELEGATION_PARAM, enableDelegation);
      }
      if (principalAccount != null) {
        jsonObject.put(PRINCIPAL_ACCOUNT_PARAM, principalAccount);
      }
      if (overviewAccounts != null) {
        jsonObject.put(OVERVIEW_ACCOUNTS_PARAM, new JSONArray(overviewAccounts));
      }
      if (addresesLabels != null) {
        jsonObject.put(ADDRESSES_LABELS, new JSONArray(addresesLabels.stream().map(label -> new JSONObject(label)).collect(Collectors.toSet())));
      }
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  public static final WalletPreferences parseStringToObject(String jsonString) {
    if (StringUtils.isBlank(jsonString)) {
      return null;
    }
    try {
      JSONObject jsonObject = new JSONObject(jsonString);
      WalletPreferences userPreferences = new WalletPreferences();
      if (jsonObject.has(CURRENCY_PARAM)) {
        userPreferences.setCurrency(jsonObject.getString(CURRENCY_PARAM));
      }
      if (jsonObject.has(DEFAULT_GAS_PARAM)) {
        userPreferences.setDefaultGas(jsonObject.getLong(DEFAULT_GAS_PARAM));
      }
      if (jsonObject.has(WALLET_ADDRESS_PARAM)) {
        userPreferences.setWalletAddress(jsonObject.getString(WALLET_ADDRESS_PARAM));
      }
      if (jsonObject.has(PHRASE_PARAM)) {
        userPreferences.setWalletAddress(jsonObject.getString(PHRASE_PARAM));
      }
      if (jsonObject.has(PRINCIPAL_ACCOUNT_PARAM)) {
        userPreferences.setPrincipalAccount(jsonObject.getString(PRINCIPAL_ACCOUNT_PARAM));
      }
      if (jsonObject.has(ENABLE_DELEGATION_PARAM)) {
        userPreferences.setEnableDelegation(jsonObject.getBoolean(ENABLE_DELEGATION_PARAM));
      }
      if (jsonObject.has(DATA_VERSION_PARAM)) {
        userPreferences.setDataVersion(jsonObject.getInt(DATA_VERSION_PARAM));
      }
      userPreferences.setOverviewAccounts(jsonArrayToList(jsonObject, OVERVIEW_ACCOUNTS_PARAM));
      return userPreferences;
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting JSON String to Object", e);
    }
  }

  @Override
  public String toString() {
    return toJSONString();
  }

  @java.lang.SuppressWarnings("all")
  public String getWalletAddress() {
    return this.walletAddress;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getDataVersion() {
    return this.dataVersion;
  }

  @java.lang.SuppressWarnings("all")
  public Long getDefaultGas() {
    return this.defaultGas;
  }

  @java.lang.SuppressWarnings("all")
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  public String getPhrase() {
    return this.phrase;
  }

  @java.lang.SuppressWarnings("all")
  public String getPrincipalAccount() {
    return this.principalAccount;
  }

  @java.lang.SuppressWarnings("all")
  public Set<String> getOverviewAccounts() {
    return this.overviewAccounts;
  }

  @java.lang.SuppressWarnings("all")
  public Boolean getEnableDelegation() {
    return this.enableDelegation;
  }

  @java.lang.SuppressWarnings("all")
  public Wallet getWallet() {
    return this.wallet;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isHasKeyOnServerSide() {
    return this.hasKeyOnServerSide;
  }

  @java.lang.SuppressWarnings("all")
  public Set<AddressLabel> getAddresesLabels() {
    return this.addresesLabels;
  }

  @java.lang.SuppressWarnings("all")
  public void setWalletAddress(final String walletAddress) {
    this.walletAddress = walletAddress;
  }

  @java.lang.SuppressWarnings("all")
  public void setDataVersion(final Integer dataVersion) {
    this.dataVersion = dataVersion;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultGas(final Long defaultGas) {
    this.defaultGas = defaultGas;
  }

  @java.lang.SuppressWarnings("all")
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  public void setPhrase(final String phrase) {
    this.phrase = phrase;
  }

  @java.lang.SuppressWarnings("all")
  public void setPrincipalAccount(final String principalAccount) {
    this.principalAccount = principalAccount;
  }

  @java.lang.SuppressWarnings("all")
  public void setOverviewAccounts(final Set<String> overviewAccounts) {
    this.overviewAccounts = overviewAccounts;
  }

  @java.lang.SuppressWarnings("all")
  public void setEnableDelegation(final Boolean enableDelegation) {
    this.enableDelegation = enableDelegation;
  }

  @java.lang.SuppressWarnings("all")
  public void setWallet(final Wallet wallet) {
    this.wallet = wallet;
  }

  @java.lang.SuppressWarnings("all")
  public void setHasKeyOnServerSide(final boolean hasKeyOnServerSide) {
    this.hasKeyOnServerSide = hasKeyOnServerSide;
  }

  @java.lang.SuppressWarnings("all")
  public void setAddresesLabels(final Set<AddressLabel> addresesLabels) {
    this.addresesLabels = addresesLabels;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof WalletPreferences)) return false;
    final WalletPreferences other = (WalletPreferences) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$walletAddress = this.getWalletAddress();
    final java.lang.Object other$walletAddress = other.getWalletAddress();
    if (this$walletAddress == null ? other$walletAddress != null : !this$walletAddress.equals(other$walletAddress)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof WalletPreferences;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $walletAddress = this.getWalletAddress();
    result = result * PRIME + ($walletAddress == null ? 43 : $walletAddress.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public WalletPreferences() {
  }
}
