/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.contract;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import rx.Observable;
import rx.functions.Func1;

public class ERTTokenV1
extends Contract {
    private static final String BINARY = "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";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_SETGASPRICELIMIT = "setGasPriceLimit";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_GETALLOWANCE = "getAllowance";
    public static final String FUNC_GETGASPRICELIMIT = "getGasPriceLimit";
    public static final String FUNC_INITIALIZED = "initialized";
    public static final String FUNC_REMOVEADMIN = "removeAdmin";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_UPGRADETO = "upgradeTo";
    public static final String FUNC_BURN = "burn";
    public static final String FUNC_ISADMIN = "isAdmin";
    public static final String FUNC_ADDADMIN = "addAdmin";
    public static final String FUNC_VERSION = "version";
    public static final String FUNC_PAUSED = "paused";
    public static final String FUNC_DISAPPROVEACCOUNT = "disapproveAccount";
    public static final String FUNC_SETTOKENPRICE = "setTokenPrice";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_SETDATAADDRESS = "setDataAddress";
    public static final String FUNC_MINTTOKEN = "mintToken";
    public static final String FUNC_GETGASPRICEINTOKEN = "getGasPriceInToken";
    public static final String FUNC_PAUSE = "pause";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_GETDATAADDRESS = "getDataAddress";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_SETPROXY = "setProxy";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_ISAPPROVEDACCOUNT = "isApprovedAccount";
    public static final String FUNC_ISPAUSED = "isPaused";
    public static final String FUNC_SETSYMBOL = "setSymbol";
    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";
    public static final String FUNC_SETNAME = "setName";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_INITIALIZE = "initialize";
    public static final String FUNC_BALANCE = "balance";
    public static final String FUNC_PROXY = "proxy";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_UNPAUSE = "unPause";
    public static final String FUNC_APPROVEACCOUNT = "approveAccount";
    public static final Event MINTEDTOKEN_EVENT = new Event("MintedToken", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Address>(){}, new TypeReference<Uint256>(){}));
    public static final Event TOKENPRICECHANGED_EVENT = new Event("TokenPriceChanged", Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
    public static final Event TRANSACTIONFEE_EVENT = new Event("TransactionFee", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
    public static final Event NOSUFFICIENTFUND_EVENT = new Event("NoSufficientFund", Arrays.asList(new TypeReference<Uint256>(){}));
    public static final Event DEPOSITRECEIVED_EVENT = new Event("DepositReceived", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event APPROVEDACCOUNT_EVENT = new Event("ApprovedAccount", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event DISAPPROVEDACCOUNT_EVENT = new Event("DisapprovedAccount", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event CONTRACTPAUSED_EVENT = new Event("ContractPaused", Arrays.asList(new TypeReference[0]));
    public static final Event CONTRACTUNPAUSED_EVENT = new Event("ContractUnPaused", Arrays.asList(new TypeReference[0]));
    public static final Event BURN_EVENT = new Event("Burn", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}));
    public static final Event ADDEDADMIN_EVENT = new Event("AddedAdmin", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint8>(){}));
    public static final Event REMOVEDADMIN_EVENT = new Event("RemovedAdmin", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event TRANSFERPROXYOWNERSHIP_EVENT = new Event("TransferProxyOwnership", Arrays.asList(new TypeReference<Address>(){}));

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<String> name() {
        Function function = new Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setGasPriceLimit(BigInteger _gasPriceLimit) {
        Function function = new Function(FUNC_SETGASPRICELIMIT, Arrays.asList(new Uint256(_gasPriceLimit)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> approve(String _spender, BigInteger _value) {
        Function function = new Function(FUNC_APPROVE, Arrays.asList(new Address(_spender), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> getAllowance(String _account, String _spender) {
        Function function = new Function(FUNC_GETALLOWANCE, Arrays.asList(new Address(_account), new Address(_spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<BigInteger> getGasPriceLimit() {
        Function function = new Function(FUNC_GETGASPRICELIMIT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> initialized() {
        Function function = new Function(FUNC_INITIALIZED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> removeAdmin(String _target) {
        Function function = new Function(FUNC_REMOVEADMIN, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> totalSupply() {
        Function function = new Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> transferFrom(String _from, String _to, BigInteger _value) {
        Function function = new Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(_from), new Address(_to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> decimals() {
        Function function = new Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> upgradeTo(String _newImplementation) {
        Function function = new Function(FUNC_UPGRADETO, Arrays.asList(new Address(_newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> burn(BigInteger _value) {
        Function function = new Function(FUNC_BURN, Arrays.asList(new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> isAdmin(String _target, BigInteger _level) {
        Function function = new Function(FUNC_ISADMIN, Arrays.asList(new Address(_target), new Uint8(_level)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> addAdmin(String _target, BigInteger _level) {
        Function function = new Function(FUNC_ADDADMIN, Arrays.asList(new Address(_target), new Uint8(_level)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> version() {
        Function function = new Function(FUNC_VERSION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint16>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> paused() {
        Function function = new Function(FUNC_PAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> disapproveAccount(String _target) {
        Function function = new Function(FUNC_DISAPPROVEACCOUNT, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> setTokenPrice(BigInteger _value) {
        Function function = new Function(FUNC_SETTOKENPRICE, Arrays.asList(new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balanceOf(String _target) {
        Function function = new Function(FUNC_BALANCEOF, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> setDataAddress(BigInteger _dataVersion, String _dataAddress) {
        Function function = new Function(FUNC_SETDATAADDRESS, Arrays.asList(new Uint16(_dataVersion), new Address(_dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> mintToken(String _target, BigInteger _mintedAmount) {
        Function function = new Function(FUNC_MINTTOKEN, Arrays.asList(new Address(_target), new Uint256(_mintedAmount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> getGasPriceInToken() {
        Function function = new Function(FUNC_GETGASPRICEINTOKEN, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> pause() {
        Function function = new Function(FUNC_PAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> getDataAddress(BigInteger _version) {
        Function function = new Function(FUNC_GETDATAADDRESS, Arrays.asList(new Uint16(_version)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> symbol() {
        Function function = new Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setProxy(String _proxy) {
        Function function = new Function(FUNC_SETPROXY, Arrays.asList(new Address(_proxy)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> transfer(String _to, BigInteger _value) {
        Function function = new Function(FUNC_TRANSFER, Arrays.asList(new Address(_to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> isApprovedAccount(String _target) {
        Function function = new Function(FUNC_ISAPPROVEDACCOUNT, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<Boolean> isPaused() {
        Function function = new Function(FUNC_ISPAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> setSymbol(String _symbol) {
        Function function = new Function(FUNC_SETSYMBOL, Arrays.asList(new Utf8String(_symbol)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> implementationAddress() {
        Function function = new Function(FUNC_IMPLEMENTATIONADDRESS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setName(String _name) {
        Function function = new Function(FUNC_SETNAME, Arrays.asList(new Utf8String(_name)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> allowance(String _target, String _spender) {
        Function function = new Function(FUNC_ALLOWANCE, Arrays.asList(new Address(_target), new Address(_spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> initialize(String _proxyAddress, BigInteger _initialAmount, String _tokenName, BigInteger _decimalUnits, String _tokenSymbol) {
        Function function = new Function(FUNC_INITIALIZE, Arrays.asList(new Address(_proxyAddress), new Uint256(_initialAmount), new Utf8String(_tokenName), new Uint8(_decimalUnits), new Utf8String(_tokenSymbol)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balance(String _target) {
        Function function = new Function(FUNC_BALANCE, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<String> proxy() {
        Function function = new Function(FUNC_PROXY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> transferOwnership(String _newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(_newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> unPause() {
        Function function = new Function(FUNC_UNPAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> approveAccount(String _target) {
        Function function = new Function(FUNC_APPROVEACCOUNT, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _dataAddress, String _proxyAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(_dataAddress), new Address(_proxyAddress)));
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _dataAddress, String _proxyAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(_dataAddress), new Address(_proxyAddress)));
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _dataAddress, String _proxyAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(_dataAddress), new Address(_proxyAddress)));
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _dataAddress, String _proxyAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(_dataAddress), new Address(_proxyAddress)));
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    public List<MintedTokenEventResponse> getMintedTokenEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(MINTEDTOKEN_EVENT, transactionReceipt);
        ArrayList<MintedTokenEventResponse> responses = new ArrayList<MintedTokenEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MintedTokenEventResponse typedResponse = new MintedTokenEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.minter = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.mintedAmount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<MintedTokenEventResponse> mintedTokenEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, MintedTokenEventResponse>(){

            public MintedTokenEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(MINTEDTOKEN_EVENT, log);
                MintedTokenEventResponse typedResponse = new MintedTokenEventResponse();
                typedResponse.log = log;
                typedResponse.minter = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.mintedAmount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<MintedTokenEventResponse> mintedTokenEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MINTEDTOKEN_EVENT));
        return this.mintedTokenEventObservable(filter);
    }

    public List<TokenPriceChangedEventResponse> getTokenPriceChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, transactionReceipt);
        ArrayList<TokenPriceChangedEventResponse> responses = new ArrayList<TokenPriceChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.tokenPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.gasPriceInToken = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.gasPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TokenPriceChangedEventResponse> tokenPriceChangedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TokenPriceChangedEventResponse>(){

            public TokenPriceChangedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, log);
                TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
                typedResponse.log = log;
                typedResponse.tokenPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.gasPriceInToken = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.gasPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TokenPriceChangedEventResponse> tokenPriceChangedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TOKENPRICECHANGED_EVENT));
        return this.tokenPriceChangedEventObservable(filter);
    }

    public List<TransactionFeeEventResponse> getTransactionFeeEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSACTIONFEE_EVENT, transactionReceipt);
        ArrayList<TransactionFeeEventResponse> responses = new ArrayList<TransactionFeeEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.tokenFee = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.etherFeeRefund = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransactionFeeEventResponse> transactionFeeEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransactionFeeEventResponse>(){

            public TransactionFeeEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSACTIONFEE_EVENT, log);
                TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.tokenFee = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.etherFeeRefund = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransactionFeeEventResponse> transactionFeeEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSACTIONFEE_EVENT));
        return this.transactionFeeEventObservable(filter);
    }

    public List<NoSufficientFundEventResponse> getNoSufficientFundEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, transactionReceipt);
        ArrayList<NoSufficientFundEventResponse> responses = new ArrayList<NoSufficientFundEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.balance = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<NoSufficientFundEventResponse> noSufficientFundEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, NoSufficientFundEventResponse>(){

            public NoSufficientFundEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, log);
                NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
                typedResponse.log = log;
                typedResponse.balance = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<NoSufficientFundEventResponse> noSufficientFundEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NOSUFFICIENTFUND_EVENT));
        return this.noSufficientFundEventObservable(filter);
    }

    public List<DepositReceivedEventResponse> getDepositReceivedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, transactionReceipt);
        ArrayList<DepositReceivedEventResponse> responses = new ArrayList<DepositReceivedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<DepositReceivedEventResponse> depositReceivedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, DepositReceivedEventResponse>(){

            public DepositReceivedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, log);
                DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<DepositReceivedEventResponse> depositReceivedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DEPOSITRECEIVED_EVENT));
        return this.depositReceivedEventObservable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferEventResponse> transferEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransferEventResponse>(){

            public TransferEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferEventResponse> transferEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventObservable(filter);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ApprovalEventResponse> approvalEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, ApprovalEventResponse>(){

            public ApprovalEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<ApprovalEventResponse> approvalEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVAL_EVENT));
        return this.approvalEventObservable(filter);
    }

    public List<ApprovedAccountEventResponse> getApprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<ApprovedAccountEventResponse> responses = new ArrayList<ApprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ApprovedAccountEventResponse> approvedAccountEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, ApprovedAccountEventResponse>(){

            public ApprovedAccountEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, log);
                ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<ApprovedAccountEventResponse> approvedAccountEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVEDACCOUNT_EVENT));
        return this.approvedAccountEventObservable(filter);
    }

    public List<DisapprovedAccountEventResponse> getDisapprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<DisapprovedAccountEventResponse> responses = new ArrayList<DisapprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<DisapprovedAccountEventResponse> disapprovedAccountEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, DisapprovedAccountEventResponse>(){

            public DisapprovedAccountEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, log);
                DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<DisapprovedAccountEventResponse> disapprovedAccountEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DISAPPROVEDACCOUNT_EVENT));
        return this.disapprovedAccountEventObservable(filter);
    }

    public List<ContractPausedEventResponse> getContractPausedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CONTRACTPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractPausedEventResponse> responses = new ArrayList<ContractPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ContractPausedEventResponse> contractPausedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, ContractPausedEventResponse>(){

            public ContractPausedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(CONTRACTPAUSED_EVENT, log);
                ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Observable<ContractPausedEventResponse> contractPausedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTRACTPAUSED_EVENT));
        return this.contractPausedEventObservable(filter);
    }

    public List<ContractUnPausedEventResponse> getContractUnPausedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractUnPausedEventResponse> responses = new ArrayList<ContractUnPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ContractUnPausedEventResponse> contractUnPausedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, ContractUnPausedEventResponse>(){

            public ContractUnPausedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, log);
                ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Observable<ContractUnPausedEventResponse> contractUnPausedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTRACTUNPAUSED_EVENT));
        return this.contractUnPausedEventObservable(filter);
    }

    public List<BurnEventResponse> getBurnEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(BURN_EVENT, transactionReceipt);
        ArrayList<BurnEventResponse> responses = new ArrayList<BurnEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            BurnEventResponse typedResponse = new BurnEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.burner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<BurnEventResponse> burnEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, BurnEventResponse>(){

            public BurnEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(BURN_EVENT, log);
                BurnEventResponse typedResponse = new BurnEventResponse();
                typedResponse.log = log;
                typedResponse.burner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<BurnEventResponse> burnEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)BURN_EVENT));
        return this.burnEventObservable(filter);
    }

    public List<AddedAdminEventResponse> getAddedAdminEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(ADDEDADMIN_EVENT, transactionReceipt);
        ArrayList<AddedAdminEventResponse> responses = new ArrayList<AddedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.level = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<AddedAdminEventResponse> addedAdminEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, AddedAdminEventResponse>(){

            public AddedAdminEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(ADDEDADMIN_EVENT, log);
                AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.level = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<AddedAdminEventResponse> addedAdminEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADDEDADMIN_EVENT));
        return this.addedAdminEventObservable(filter);
    }

    public List<RemovedAdminEventResponse> getRemovedAdminEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(REMOVEDADMIN_EVENT, transactionReceipt);
        ArrayList<RemovedAdminEventResponse> responses = new ArrayList<RemovedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<RemovedAdminEventResponse> removedAdminEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, RemovedAdminEventResponse>(){

            public RemovedAdminEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(REMOVEDADMIN_EVENT, log);
                RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<RemovedAdminEventResponse> removedAdminEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REMOVEDADMIN_EVENT));
        return this.removedAdminEventObservable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransferOwnershipEventResponse>(){

            public TransferOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFEROWNERSHIP_EVENT));
        return this.transferOwnershipEventObservable(filter);
    }

    public List<TransferProxyOwnershipEventResponse> getTransferProxyOwnershipEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFERPROXYOWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferProxyOwnershipEventResponse> responses = new ArrayList<TransferProxyOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferProxyOwnershipEventResponse typedResponse = new TransferProxyOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.proxy = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferProxyOwnershipEventResponse> transferProxyOwnershipEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransferProxyOwnershipEventResponse>(){

            public TransferProxyOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFERPROXYOWNERSHIP_EVENT, log);
                TransferProxyOwnershipEventResponse typedResponse = new TransferProxyOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.proxy = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferProxyOwnershipEventResponse> transferProxyOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFERPROXYOWNERSHIP_EVENT));
        return this.transferProxyOwnershipEventObservable(filter);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static class TransferProxyOwnershipEventResponse {
        public Log log;
        public String proxy;
    }

    public static class TransferOwnershipEventResponse {
        public Log log;
        public String newOwner;
    }

    public static class RemovedAdminEventResponse {
        public Log log;
        public String target;
    }

    public static class AddedAdminEventResponse {
        public Log log;
        public String target;
        public BigInteger level;
    }

    public static class BurnEventResponse {
        public Log log;
        public String burner;
        public BigInteger value;
    }

    public static class ContractUnPausedEventResponse {
        public Log log;
    }

    public static class ContractPausedEventResponse {
        public Log log;
    }

    public static class DisapprovedAccountEventResponse {
        public Log log;
        public String target;
    }

    public static class ApprovedAccountEventResponse {
        public Log log;
        public String target;
    }

    public static class ApprovalEventResponse {
        public Log log;
        public String _owner;
        public String _spender;
        public BigInteger _value;
    }

    public static class TransferEventResponse {
        public Log log;
        public String _from;
        public String _to;
        public BigInteger _value;
    }

    public static class DepositReceivedEventResponse {
        public Log log;
        public String from;
        public BigInteger amount;
    }

    public static class NoSufficientFundEventResponse {
        public Log log;
        public BigInteger balance;
    }

    public static class TransactionFeeEventResponse {
        public Log log;
        public String from;
        public BigInteger tokenFee;
        public BigInteger etherFeeRefund;
    }

    public static class TokenPriceChangedEventResponse {
        public Log log;
        public BigInteger tokenPrice;
        public BigInteger gasPriceInToken;
        public BigInteger gasPrice;
    }

    public static class MintedTokenEventResponse {
        public Log log;
        public String minter;
        public String target;
        public BigInteger mintedAmount;
    }
}

