/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import java.math.BigInteger;
import java.util.List;
import org.exoplatform.addon.ethereum.wallet.fork.ContractUtils;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.ContractTransactionDetail;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.TransactionStatus;
import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.web3j.abi.EventValues;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.utils.Convert;

public class EthereumTransactionProcessorListener
extends Listener<Transaction, TransactionReceipt> {
    private static final Log LOG = ExoLogger.getLogger(EthereumTransactionProcessorListener.class);
    private EthereumWalletService ethereumWalletService;
    private EthereumClientConnector ethereumClientConnector;

    public EthereumTransactionProcessorListener(EthereumWalletService ethereumWalletService, EthereumClientConnector ethereumClientConnector) {
        this.ethereumWalletService = ethereumWalletService;
        this.ethereumClientConnector = ethereumClientConnector;
    }

    public void onEvent(Event<Transaction, TransactionReceipt> event) throws Exception {
        TransactionStatus transactionStatus;
        Transaction transaction = (Transaction)event.getSource();
        if (transaction == null) {
            return;
        }
        String senderAddress = transaction.getFrom();
        String receiverAddress = null;
        String contractAddress = null;
        AccountDetail sender = null;
        AccountDetail receiver = null;
        ContractDetail contractDetails = null;
        BigInteger amountBigInteger = transaction.getValue();
        double amount = Convert.fromWei((String)amountBigInteger.toString(), (Convert.Unit)Convert.Unit.ETHER).doubleValue();
        boolean isContractTransaction = amount == 0.0;
        boolean sendNotification = true;
        GlobalSettings settings = this.ethereumWalletService.getSettings();
        if (isContractTransaction) {
            contractAddress = transaction.getTo();
            if (contractAddress == null) {
                sendNotification = false;
            } else {
                try {
                    ContractTransactionDetail contractTransactionDetail = this.getReceiverAddressFromContractData(settings, transaction);
                    if (contractTransactionDetail == null) {
                        sendNotification = false;
                    } else {
                        amount = contractTransactionDetail.getAmount();
                        receiverAddress = contractTransactionDetail.getReceiver();
                    }
                }
                catch (IllegalStateException e) {
                    isContractTransaction = false;
                }
            }
        }
        if (!isContractTransaction) {
            receiverAddress = transaction.getTo();
        }
        if (senderAddress != null) {
            sender = this.getAccountDetail(senderAddress);
        }
        if (receiverAddress != null) {
            receiver = this.getAccountDetail(receiverAddress);
        }
        if (contractAddress != null && isContractTransaction && (contractDetails = this.ethereumWalletService.getDefaultContractDetail(contractAddress, settings.getDefaultNetworkId())) == null) {
            contractDetails = new ContractDetail(settings.getDefaultNetworkId(), contractAddress, contractAddress, contractAddress);
        }
        if (sendNotification && senderAddress != null && receiverAddress != null && (sender.getId() != null || receiver.getId() != null)) {
            if (isContractTransaction) {
                LOG.info("Sending notification for contract {} transaction from {} to {} with amount {}", new Object[]{contractAddress, sender.getId() != null ? sender.getId() : senderAddress, receiver.getId() != null ? receiver.getId() : receiverAddress, amount});
            } else {
                LOG.info("Sending notification for ether transaction from {} to {} with amount {} ether", new Object[]{sender.getId() != null ? sender.getId() : senderAddress, receiver.getId() != null ? receiver.getId() : receiverAddress, amount});
            }
        }
        boolean transactionStatusOk = false;
        if (sender != null && sender.getId() != null) {
            if (sendNotification) {
                TransactionStatus transactionStatus2 = transactionStatus = isContractTransaction ? TransactionStatus.CONTRACT_SENDER : TransactionStatus.SENDER;
                if (isContractTransaction || this.checkTransactionStatus(transaction) != null) {
                    transactionStatusOk = true;
                    this.sendNotification(sender, receiver, contractDetails, transactionStatus, amount);
                }
            }
            this.ethereumWalletService.saveAccountTransaction(settings.getDefaultNetworkId(), sender.getAddress(), transaction.getHash());
        }
        if (!(receiver == null || receiver.getId() == null || sender != null && sender.getId() != null && sender.getId().equals(receiver.getId()))) {
            if (sendNotification) {
                TransactionStatus transactionStatus3 = transactionStatus = isContractTransaction ? TransactionStatus.CONTRACT_RECEIVER : TransactionStatus.RECEIVER;
                if (isContractTransaction || transactionStatusOk || this.checkTransactionStatus(transaction) != null) {
                    this.sendNotification(sender, receiver, contractDetails, transactionStatus, amount);
                }
            }
            this.ethereumWalletService.saveAccountTransaction(settings.getDefaultNetworkId(), receiver.getAddress(), transaction.getHash());
        }
    }

    private void sendNotification(AccountDetail senderAccountDetails, AccountDetail receiverAccountDetails, ContractDetail contractDetails, TransactionStatus transactionStatus, double amount) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)senderAccountDetails);
        ctx.append(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)receiverAccountDetails);
        if (contractDetails != null) {
            ctx.append(Utils.CONTRACT_DETAILS_PARAMETER, (Object)contractDetails);
        }
        ctx.append(Utils.AMOUNT_PARAMETER, (Object)amount);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)transactionStatus.getNotificationId()))).execute(ctx);
    }

    private ContractTransactionDetail getReceiverAddressFromContractData(GlobalSettings settings, Transaction transaction) throws Exception {
        if (transaction == null || transaction.getTo() == null) {
            return null;
        }
        String contractAddress = transaction.getTo();
        List<String> defaultContracts = settings.getDefaultContractsToDisplay();
        if (defaultContracts != null && defaultContracts.contains(contractAddress) && transaction.getInput() != null && !transaction.getInput().equals("0x")) {
            TransactionReceipt transactionReceipt = this.checkTransactionStatus(transaction);
            if (transactionReceipt == null || transactionReceipt.getLogs() == null || transactionReceipt.getLogs().size() == 0) {
                return null;
            }
            if (transactionReceipt.getLogs().size() > 1) {
                LOG.info("Transaction logs count is more than expected: {}", new Object[]{transactionReceipt.getLogs().size()});
            }
            try {
                EventValues eventValues = ContractUtils.staticExtractEventParameters(Utils.CONTRACT_TRANSFER_EVENT, (org.web3j.protocol.core.methods.response.Log)transactionReceipt.getLogs().get(0));
                if (eventValues != null && eventValues.getIndexedValues() != null && eventValues.getNonIndexedValues() != null && eventValues.getIndexedValues().size() == 2 && eventValues.getNonIndexedValues().size() == 1) {
                    String senderAddress = ((Type)eventValues.getIndexedValues().get(0)).getValue().toString();
                    String receiverAddress = ((Type)eventValues.getIndexedValues().get(1)).getValue().toString();
                    String amountBigInteger = ((Type)eventValues.getNonIndexedValues().get(0)).getValue().toString();
                    return new ContractTransactionDetail(contractAddress, senderAddress, receiverAddress, Double.parseDouble(amountBigInteger));
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)"Error occurred while parsing transaction", e);
            }
        }
        return null;
    }

    private TransactionReceipt checkTransactionStatus(Transaction transaction) throws Exception {
        TransactionReceipt transactionReceipt = this.ethereumClientConnector.getTransactionReceipt(transaction.getHash());
        if (transactionReceipt == null || "0x0".equals(transactionReceipt.getStatus())) {
            return null;
        }
        return transactionReceipt;
    }

    private AccountDetail getAccountDetail(String address) {
        AccountDetail accountDetails = this.ethereumWalletService.getAccountDetailsByAddress(address);
        if (accountDetails == null) {
            accountDetails = new AccountDetail(null, null, null, address, address, false, "/eXoSkin/skin/images/system/UserAvtDefault.png");
        }
        return accountDetails;
    }
}

