/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/contract")
@RolesAllowed(value={"administrators"})
public class EthereumWalletContractREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletContractREST.class);
    private EthereumWalletService ethereumWalletService;

    public EthereumWalletContractREST(EthereumWalletService ethereumWalletService) {
        this.ethereumWalletService = ethereumWalletService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="save")
    public Response saveContract(ContractDetail contractDetail) {
        if (contractDetail == null) {
            LOG.warn((Object)"Can't save empty contract");
            return Response.status((int)400).build();
        }
        if (contractDetail.getAddress() == null) {
            LOG.warn((Object)"Can't save empty address for contract");
            return Response.status((int)400).build();
        }
        if (contractDetail.getNetworkId() == null || contractDetail.getNetworkId() == 0L) {
            LOG.warn((Object)"Can't remove empty network id for contract");
            return Response.status((int)400).build();
        }
        this.ethereumWalletService.saveDefaultContract(contractDetail);
        return Response.ok().build();
    }

    @POST
    @Path(value="remove")
    public Response removeContract(@FormParam(value="address") String address, @FormParam(value="networkId") Long networkId) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Can't remove empty address for contract");
            return Response.status((int)400).build();
        }
        if (networkId == null || networkId == 0L) {
            LOG.warn((Object)"Can't remove empty network id for contract");
            return Response.status((int)400).build();
        }
        this.ethereumWalletService.removeDefaultContract(address, networkId);
        return Response.ok().build();
    }
}

