/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.notification.plugin;

import java.util.List;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.TransactionStatus;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;

public class EtherSenderNotificationPlugin
extends BaseNotificationPlugin {
    public EtherSenderNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return TransactionStatus.SENDER.getNotificationId();
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        AccountDetail senderAccountDetail = (AccountDetail)ctx.value(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER);
        AccountDetail receiverAccountDetail = (AccountDetail)ctx.value(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER);
        double amount = (Double)ctx.value(Utils.AMOUNT_PARAMETER);
        String message = (String)ctx.value(Utils.MESSAGE_PARAMETER);
        String hash = (String)ctx.value(Utils.HASH_PARAMETER);
        List<String> toList = Utils.getNotificationReceiversUsers(senderAccountDetail, receiverAccountDetail.getId());
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        return NotificationInfo.instance().to(toList).with("amount", String.valueOf(amount)).with("message", message).with("hash", hash).with("account_type", senderAccountDetail.getType()).with("avatar", CommonsUtils.getCurrentDomain() + receiverAccountDetail.getAvatar()).with("senderUrl", Utils.getPermanentLink(senderAccountDetail)).with("receiverUrl", Utils.getPermanentLink(receiverAccountDetail)).with("sender", senderAccountDetail.getName()).with("receiver", receiverAccountDetail.getName()).key(this.getKey()).end();
    }
}

