/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.contract;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import rx.Observable;
import rx.functions.Func1;

public class Upgradability
extends Contract {
    private static final String BINARY = "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";
    public static final String FUNC_UPGRADETO = "upgradeTo";
    public static final String FUNC_VERSION = "version";
    public static final String FUNC_PAUSED = "paused";
    public static final String FUNC_SETDATAADDRESS = "setDataAddress";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_SETPROXY = "setProxy";
    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";
    public static final String FUNC_PROXY = "proxy";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event TRANSFERPROXYOWNERSHIP_EVENT = new Event("TransferProxyOwnership", Arrays.asList(new TypeReference<Address>(){}));

    @Deprecated
    protected Upgradability(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected Upgradability(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected Upgradability(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected Upgradability(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<TransactionReceipt> upgradeTo(String _newImplementation) {
        Function function = new Function(FUNC_UPGRADETO, Arrays.asList(new Address(_newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> version() {
        Function function = new Function(FUNC_VERSION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint16>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> paused() {
        Function function = new Function(FUNC_PAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> setDataAddress(BigInteger _dataVersion, String _dataAddress) {
        Function function = new Function(FUNC_SETDATAADDRESS, Arrays.asList(new Uint16(_dataVersion), new Address(_dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setProxy(String _proxy) {
        Function function = new Function(FUNC_SETPROXY, Arrays.asList(new Address(_proxy)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> implementationAddress() {
        Function function = new Function(FUNC_IMPLEMENTATIONADDRESS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> proxy() {
        Function function = new Function(FUNC_PROXY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> transferOwnership(String _newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(_newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransferOwnershipEventResponse>(){

            public TransferOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = Upgradability.this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFEROWNERSHIP_EVENT));
        return this.transferOwnershipEventObservable(filter);
    }

    public List<TransferProxyOwnershipEventResponse> getTransferProxyOwnershipEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFERPROXYOWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferProxyOwnershipEventResponse> responses = new ArrayList<TransferProxyOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferProxyOwnershipEventResponse typedResponse = new TransferProxyOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.proxy = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferProxyOwnershipEventResponse> transferProxyOwnershipEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransferProxyOwnershipEventResponse>(){

            public TransferProxyOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = Upgradability.this.extractEventParametersWithLog(TRANSFERPROXYOWNERSHIP_EVENT, log);
                TransferProxyOwnershipEventResponse typedResponse = new TransferProxyOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.proxy = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferProxyOwnershipEventResponse> transferProxyOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFERPROXYOWNERSHIP_EVENT));
        return this.transferProxyOwnershipEventObservable(filter);
    }

    public static RemoteCall<Upgradability> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return Upgradability.deployRemoteCall(Upgradability.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<Upgradability> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return Upgradability.deployRemoteCall(Upgradability.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static RemoteCall<Upgradability> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return Upgradability.deployRemoteCall(Upgradability.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<Upgradability> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return Upgradability.deployRemoteCall(Upgradability.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    @Deprecated
    public static Upgradability load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new Upgradability(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static Upgradability load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new Upgradability(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static Upgradability load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new Upgradability(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static Upgradability load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new Upgradability(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static class TransferProxyOwnershipEventResponse {
        public Log log;
        public String proxy;
    }

    public static class TransferOwnershipEventResponse {
        public Log log;
        public String newOwner;
    }
}

