/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.ext.kudos.model.KudosTransaction;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.json.JSONObject;

public class ExtendedWalletService {
    private SettingService settingService;
    private Double tokensPerKudos;
    private String kudosContractAddress;

    public ExtendedWalletService(SettingService settingService) {
        this.settingService = settingService;
    }

    public double getTokensPerKudos() {
        if (this.tokensPerKudos == null) {
            SettingValue value = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "TOKENS_PER_KUDOS");
            this.tokensPerKudos = value == null ? 0.0 : Double.parseDouble(value.getValue().toString());
        }
        return this.tokensPerKudos;
    }

    public String getKudosContract() {
        if (this.kudosContractAddress == null) {
            SettingValue value = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "KUDOS_CONTRACT_ADDRESS");
            this.kudosContractAddress = value == null ? "" : value.getValue().toString();
        }
        return this.kudosContractAddress;
    }

    public void saveTokensPerKudos(double tokensPerKudos) {
        this.settingService.set(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "TOKENS_PER_KUDOS", SettingValue.create((Double)tokensPerKudos));
        this.tokensPerKudos = null;
    }

    public void saveKudosContract(String kudosContractAddress) {
        this.settingService.set(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "KUDOS_CONTRACT_ADDRESS", SettingValue.create((String)kudosContractAddress));
        this.kudosContractAddress = null;
    }

    public List<JSONObject> getPeriodTransactions(Long networkId, String periodType, long startDateInSeconds) {
        String kudosPeriodTransactionsParamName = this.getPeriodTransactionsParamName(periodType, startDateInSeconds);
        SettingValue kudosPeriodTransactionsValue = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, kudosPeriodTransactionsParamName);
        String kudosPeriodTransactionsString = kudosPeriodTransactionsValue == null ? "" : kudosPeriodTransactionsValue.getValue().toString();
        String[] kudosPeriodTransactionsArray = kudosPeriodTransactionsString.isEmpty() ? new String[]{} : kudosPeriodTransactionsString.split(",");
        return Arrays.stream(kudosPeriodTransactionsArray).map(transaction -> {
            KudosTransaction kudosTransaction = KudosTransaction.fromStoredValue(transaction);
            kudosTransaction.setNetworkId(networkId);
            return kudosTransaction.toJSONObject();
        }).collect(Collectors.toList());
    }

    public void savePeriodKudosTransaction(KudosTransaction kudosTransaction) {
        String kudosPeriodTransactionsString;
        if (kudosTransaction == null) {
            throw new IllegalArgumentException("kudosTransaction parameter is mandatory");
        }
        if (kudosTransaction.getNetworkId() == 0L) {
            throw new IllegalArgumentException("transaction NetworkId parameter is mandatory");
        }
        if (StringUtils.isBlank((String)kudosTransaction.getHash())) {
            throw new IllegalArgumentException("transaction hash parameter is mandatory");
        }
        if (StringUtils.isBlank((String)kudosTransaction.getPeriodType())) {
            throw new IllegalArgumentException("transaction PeriodType parameter is mandatory");
        }
        if (kudosTransaction.getStartDateInSeconds() == 0L) {
            throw new IllegalArgumentException("transaction 'period start date' parameter is mandatory");
        }
        if (StringUtils.isBlank((String)kudosTransaction.getReceiverType())) {
            throw new IllegalArgumentException("transaction ReceiverType parameter is mandatory");
        }
        if (StringUtils.isBlank((String)kudosTransaction.getReceiverId())) {
            throw new IllegalArgumentException("transaction ReceiverId parameter is mandatory");
        }
        String kudosPeriodTransactionsParamName = this.getPeriodTransactionsParamName(kudosTransaction.getPeriodType(), kudosTransaction.getStartDateInSeconds());
        SettingValue kudosPeriodTransactionsValue = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, kudosPeriodTransactionsParamName);
        String string = kudosPeriodTransactionsString = kudosPeriodTransactionsValue == null ? "" : kudosPeriodTransactionsValue.getValue().toString();
        if (!kudosPeriodTransactionsString.contains(kudosTransaction.getHash())) {
            String contentToPrepend = kudosTransaction.getToStoreValue();
            kudosPeriodTransactionsString = kudosPeriodTransactionsString.isEmpty() ? contentToPrepend : contentToPrepend + "," + kudosPeriodTransactionsString;
            this.settingService.set(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, kudosPeriodTransactionsParamName, SettingValue.create((String)kudosPeriodTransactionsString));
        }
    }

    private String getPeriodTransactionsParamName(String periodType, long startDateInSeconds) {
        return "KUDOS_PERIOD_TRANSACTIONS" + periodType + startDateInSeconds;
    }
}

