/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationSettings;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationTeam;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationTransaction;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.json.JSONObject;

public class WalletGamificationService {
    private static final Log LOG = ExoLogger.getLogger(WalletGamificationService.class);
    private SettingService settingService;
    private ResourceBinder restResourceBinder;
    private GamificationSettings gamificationSettings = new GamificationSettings();
    private List<GamificationTeam> teams = new ArrayList<GamificationTeam>();
    private AbstractResourceDescriptor gamificationRestResource;
    private boolean gamificationRestSearched = false;
    private long id = 1L;

    public WalletGamificationService(ResourceBinder restResourceBinder, SettingService settingService) {
        this.settingService = settingService;
        this.restResourceBinder = restResourceBinder;
    }

    public GamificationSettings getSettings() {
        if (this.gamificationRestResource == null && !this.gamificationRestSearched) {
            try {
                List resources = this.restResourceBinder.getResources();
                this.gamificationRestResource = resources.stream().map(resource -> (AbstractResourceDescriptor)resource.getObjectModel()).filter(resource -> resource.getPathValue() != null && resource.getPathValue().getPath() != null && resource.getPathValue().getPath().contains("gamification/api")).findFirst().get();
            }
            catch (Exception e) {
                LOG.warn((Object)"Error getting gamification REST resource", (Throwable)e);
            }
            this.gamificationRestSearched = true;
        }
        if (this.gamificationRestResource != null) {
            return this.gamificationSettings;
        }
        return null;
    }

    public void saveSettings(GamificationSettings gamificationSettings) {
        this.gamificationSettings = gamificationSettings;
    }

    public List<GamificationTeam> getTeams() {
        return this.teams;
    }

    public GamificationTeam saveTeam(GamificationTeam gamificationTeam) {
        if (gamificationTeam == null) {
            throw new IllegalArgumentException("Empty team to save");
        }
        if (gamificationTeam.getId() == null || gamificationTeam.getId() == 0L) {
            gamificationTeam.setId(this.id++);
            this.teams.add(gamificationTeam);
        } else {
            GamificationTeam oldGamificationTeam = this.teams.stream().filter(team -> team.getId() == gamificationTeam.getId()).findFirst().get();
            if (oldGamificationTeam == null) {
                this.teams.add(gamificationTeam);
            } else {
                this.teams.remove(oldGamificationTeam);
                this.teams.add(gamificationTeam);
            }
        }
        return gamificationTeam;
    }

    public void removeTeam(long id) {
        if (id != 0L) {
            this.teams = this.teams.stream().filter(team -> team.getId() == id).collect(Collectors.toList());
        }
    }

    public List<JSONObject> getPeriodTransactions(Long networkId, String periodType, long startDateInSeconds) {
        String paramName = this.getPeriodTransactionsParamName(periodType, startDateInSeconds);
        SettingValue transactionsValue = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, paramName);
        String transactionsString = transactionsValue == null ? "" : transactionsValue.getValue().toString();
        String[] transactionsArray = transactionsString.isEmpty() ? new String[]{} : transactionsString.split(",");
        return Arrays.stream(transactionsArray).map(transaction -> {
            GamificationTransaction gamificationTransaction = GamificationTransaction.fromStoredValue(transaction);
            gamificationTransaction.setNetworkId(networkId);
            return gamificationTransaction.toJSONObject();
        }).collect(Collectors.toList());
    }

    public void savePeriodTransaction(GamificationTransaction gamificationTransaction) {
        String transactionsString;
        if (gamificationTransaction == null) {
            throw new IllegalArgumentException("gamificationTransaction parameter is mandatory");
        }
        if (gamificationTransaction.getNetworkId() == 0L) {
            throw new IllegalArgumentException("transaction NetworkId parameter is mandatory");
        }
        if (StringUtils.isBlank((String)gamificationTransaction.getHash())) {
            throw new IllegalArgumentException("transaction hash parameter is mandatory");
        }
        if (StringUtils.isBlank((String)gamificationTransaction.getPeriodType())) {
            throw new IllegalArgumentException("transaction PeriodType parameter is mandatory");
        }
        if (gamificationTransaction.getStartDateInSeconds() == 0L) {
            throw new IllegalArgumentException("transaction 'period start date' parameter is mandatory");
        }
        if (StringUtils.isBlank((String)gamificationTransaction.getReceiverType())) {
            throw new IllegalArgumentException("transaction ReceiverType parameter is mandatory");
        }
        if (StringUtils.isBlank((String)gamificationTransaction.getReceiverId())) {
            throw new IllegalArgumentException("transaction ReceiverId parameter is mandatory");
        }
        if (StringUtils.isBlank((String)gamificationTransaction.getReceiverIdentityId())) {
            throw new IllegalArgumentException("transaction ReceiverIdentityId parameter is mandatory");
        }
        String paramName = this.getPeriodTransactionsParamName(gamificationTransaction.getPeriodType(), gamificationTransaction.getStartDateInSeconds());
        SettingValue transactionsValue = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, paramName);
        String string = transactionsString = transactionsValue == null ? "" : transactionsValue.getValue().toString();
        if (!transactionsString.contains(gamificationTransaction.getHash())) {
            String contentToPrepend = gamificationTransaction.getToStoreValue();
            transactionsString = transactionsString.isEmpty() ? contentToPrepend : contentToPrepend + "," + transactionsString;
            this.settingService.set(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, paramName, SettingValue.create((String)transactionsString));
        }
    }

    private String getPeriodTransactionsParamName(String periodType, long startDateInSeconds) {
        return "GAMIFICATION_PERIOD_TRANSACTIONS" + periodType + startDateInSeconds;
    }
}

