/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.notification.builder;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class TemplateBuilder
extends AbstractTemplateBuilder {
    private static final Log LOG = ExoLogger.getLogger(TemplateBuilder.class);
    private TemplateProvider templateProvider;
    private boolean pushNotification;

    public TemplateBuilder(TemplateProvider templateProvider, boolean pushNotification) {
        this.templateProvider = templateProvider;
        this.pushNotification = pushNotification;
    }

    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String pluginId = notification.getKey().getId();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)this.templateProvider.getChannelKey(), (String)pluginId, (String)language);
        String amount = notification.getValueOwnerParameter("amount");
        String type = notification.getValueOwnerParameter("account_type");
        String receiverType = notification.getValueOwnerParameter("receiver_type");
        String avatar = notification.getValueOwnerParameter("avatar");
        String receiver = notification.getValueOwnerParameter("receiver");
        String sender = notification.getValueOwnerParameter("sender");
        String receiverUrl = notification.getValueOwnerParameter("receiverUrl");
        String senderUrl = notification.getValueOwnerParameter("senderUrl");
        String contractAddress = notification.getValueOwnerParameter("contractAddress");
        String symbol = notification.getValueOwnerParameter("symbol");
        String message = notification.getValueOwnerParameter("message");
        String hash = notification.getValueOwnerParameter("hash");
        String notificationRead = notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey());
        try {
            templateContext.put((Object)"AMOUNT", (Object)amount);
            templateContext.put((Object)"ACCOUNT_TYPE", (Object)type);
            templateContext.put((Object)"SENDER", (Object)sender);
            templateContext.put((Object)"RECEIVER", (Object)receiver);
            templateContext.put((Object)"SENDER_URL", (Object)senderUrl);
            templateContext.put((Object)"RECEIVER_URL", (Object)receiverUrl);
            templateContext.put((Object)"AVATAR", (Object)(avatar != null ? avatar : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"SYMBOL", (Object)symbol);
            templateContext.put((Object)"CONTRACT_ADDRESS", (Object)(contractAddress == null ? "" : contractAddress));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notificationRead) != false ? "read" : "unread"));
            templateContext.put((Object)"MESSAGE", (Object)message);
            templateContext.put((Object)"HASH", (Object)hash);
            String absoluteMyWalletLink = Utils.getWalletLink(receiverType, receiver);
            templateContext.put((Object)"BASE_URL", (Object)absoluteMyWalletLink);
            this.setLastUpdateDate(notification, language, templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            if (templateContext.getException() != null) {
                throw new IllegalStateException("An error occurred while building message", templateContext.getException());
            }
            MessageInfo messageInfo = new MessageInfo();
            if (this.pushNotification) {
                String pushNotificationLink = StringUtils.isBlank((CharSequence)hash) ? absoluteMyWalletLink : absoluteMyWalletLink + "?hash=" + hash;
                messageInfo.subject(pushNotificationLink);
            } else {
                this.addMessageSubject(messageInfo, templateContext, type);
            }
            return messageInfo.body(body).end();
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while building notification message", (Throwable)e);
            throw e;
        }
    }

    protected void setLastUpdateDate(NotificationInfo notification, String language, TemplateContext templateContext) {
        try {
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)this.getLastModifiedDate(notification, language));
        }
        catch (Exception e) {
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)"");
        }
    }

    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
        return false;
    }

    private void addMessageSubject(MessageInfo messageInfo, TemplateContext templateContext, String type) {
        String pluginId = templateContext.getPluginId();
        PluginConfig templateConfig = TemplateBuilder.getPluginConfig(pluginId);
        Element subjectElement = NotificationUtils.getSubject((PluginConfig)templateConfig, (String)(pluginId = "space".equals(type) ? "Space" + pluginId : pluginId), (String)templateContext.getLanguage());
        if (subjectElement != null && subjectElement.getTemplate() != null) {
            messageInfo.subject(subjectElement.getTemplate());
        }
    }

    private String getLastModifiedDate(NotificationInfo notification, String language) {
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(notification.getLastModifiedDate());
        return TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR);
    }

    private static PluginConfig getPluginConfig(String pluginId) {
        PluginConfig pluginConfig = NotificationContextImpl.cloneInstance().getPluginSettingService().getPluginConfig(pluginId);
        if (pluginConfig == null) {
            throw new IllegalStateException("PluginConfig is NULL with plugId = " + pluginId);
        }
        return pluginConfig;
    }
}

