/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.fork.ContractUtils;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.model.TransactionStatus;
import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.web3j.abi.EventValues;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.utils.Convert;

public class EthereumTransactionProcessorListener
extends Listener<Transaction, TransactionReceipt> {
    private static final Log LOG = ExoLogger.getLogger(EthereumTransactionProcessorListener.class);
    private EthereumWalletService ethereumWalletService;
    private EthereumClientConnector ethereumClientConnector;

    public void onEvent(Event<Transaction, TransactionReceipt> event) throws Exception {
        boolean isTransactionPendingInCache;
        BigInteger amountBigInteger;
        double amount;
        ContractDetail contractDetails;
        Transaction transaction = (Transaction)event.getSource();
        if (transaction == null) {
            return;
        }
        if (!this.getEthereumWalletService().isTransactionWatched(transaction.getHash())) {
            return;
        }
        TransactionReceipt transactionReceipt = null;
        if (this.getEthereumWalletService().getTransactionDetailFromCache(transaction.getHash()) != null) {
            transactionReceipt = this.getTransactionStatus(transaction);
            try {
                this.getEthereumWalletService().broadcastNewTransactionEvent(transaction.getHash(), null, transactionReceipt != null && transactionReceipt.isStatusOK());
            }
            catch (Exception e) {
                LOG.error((Object)("Error broadcasting finished transaction with hash " + transaction.getHash()), (Throwable)e);
            }
        }
        String senderAddress = transaction.getFrom();
        String receiverAddress = null;
        AccountDetail sender = null;
        AccountDetail receiver = null;
        GlobalSettings settings = this.getEthereumWalletService().getSettings();
        ContractDetail contractDetail = contractDetails = StringUtils.isBlank((CharSequence)transaction.getTo()) ? null : this.getEthereumWalletService().getContractDetail(transaction.getTo(), settings.getDefaultNetworkId());
        if (contractDetails != null && StringUtils.isNotBlank((CharSequence)contractDetails.getName())) {
            this.getEthereumWalletService().saveAccountTransaction(settings.getDefaultNetworkId(), transaction.getTo(), transaction.getHash(), false, null);
        }
        boolean isContractTransaction = (amount = Convert.fromWei((String)(amountBigInteger = transaction.getValue()).toString(), (Convert.Unit)Convert.Unit.ETHER).doubleValue()) == 0.0;
        boolean sendNotification = true;
        String contractAddress = null;
        if (isContractTransaction) {
            contractAddress = transaction.getTo();
            if (contractAddress == null) {
                sendNotification = false;
            } else {
                try {
                    TransactionDetail contractTransactionDetail = this.getReceiverAddressFromContractData(settings, contractDetails, transaction, transactionReceipt);
                    if (contractTransactionDetail == null) {
                        sendNotification = false;
                    } else {
                        amount = contractTransactionDetail.getContractAmount();
                        receiverAddress = contractTransactionDetail.getTo();
                    }
                }
                catch (IllegalStateException e) {
                    isContractTransaction = false;
                }
            }
        }
        if (!isContractTransaction) {
            receiverAddress = transaction.getTo();
        }
        sender = this.getAccountDetail(senderAddress);
        receiver = this.getAccountDetail(receiverAddress);
        if (sendNotification && senderAddress != null && receiverAddress != null && (sender.getId() != null || receiver.getId() != null)) {
            if (isContractTransaction) {
                LOG.info("Sending notification for contract {} transaction from {} to {} with amount {}", new Object[]{contractAddress, sender.getId() != null ? sender.getId() : senderAddress, receiver.getId() != null ? receiver.getId() : receiverAddress, amount});
            } else {
                LOG.info("Sending notification for ether transaction from {} to {} with amount {} ether", new Object[]{sender.getId() != null ? sender.getId() : senderAddress, receiver.getId() != null ? receiver.getId() : receiverAddress, amount});
            }
        }
        boolean transactionStatusOk = false;
        TransactionDetail transactionDetailFromCache = this.getEthereumWalletService().getTransactionDetailFromCache(transaction.getHash());
        boolean bl = isTransactionPendingInCache = transactionDetailFromCache != null && transactionDetailFromCache.isPending();
        if (transactionDetailFromCache != null) {
            transactionDetailFromCache.setPending(false);
            this.getEthereumWalletService().setTransactionDetailInCache(transactionDetailFromCache);
        }
        if (sender != null && sender.getId() != null) {
            if (sendNotification && isContractTransaction || this.getTransactionStatus(transaction) != null) {
                transactionStatusOk = true;
                if (!isContractTransaction && StringUtils.isBlank((CharSequence)receiver.getId()) && contractDetails != null) {
                    receiver.setName("Contract: " + contractDetails.getName());
                }
                if (isTransactionPendingInCache) {
                    this.sendNotification(transaction.getHash(), sender, receiver, contractDetails, TransactionStatus.SENDER, amount);
                }
            }
            if (transactionReceipt == null) {
                transactionReceipt = this.getTransactionStatus(transaction);
            }
            this.getEthereumWalletService().saveAccountTransaction(settings.getDefaultNetworkId(), sender.getAddress(), transaction.getHash(), true, transactionReceipt != null && transactionReceipt.isStatusOK());
        }
        if (!(receiver == null || receiver.getId() == null || sender != null && sender.getId() != null && sender.getId().equals(receiver.getId()))) {
            boolean saveLabel;
            if (sendNotification && isContractTransaction || transactionStatusOk || this.getTransactionStatus(transaction) != null) {
                if (sender != null && sender.getId() == null && settings != null && settings.getPrincipalContractAdminAddress() != null && StringUtils.equalsIgnoreCase((CharSequence)settings.getPrincipalContractAdminAddress(), (CharSequence)sender.getAddress())) {
                    sender.setName(settings.getPrincipalContractAdminName());
                }
                if (isTransactionPendingInCache) {
                    this.sendNotification(transaction.getHash(), sender, receiver, contractDetails, TransactionStatus.RECEIVER, amount);
                }
            }
            boolean bl2 = saveLabel = sender == null && "space".equals(receiver.getType());
            if (transactionReceipt == null) {
                transactionReceipt = this.getTransactionStatus(transaction);
            }
            this.getEthereumWalletService().saveAccountTransaction(settings.getDefaultNetworkId(), receiver.getAddress(), transaction.getHash(), saveLabel, transactionReceipt != null && transactionReceipt.isStatusOK());
        }
    }

    private void sendNotification(String transactionHash, AccountDetail senderAccountDetails, AccountDetail receiverAccountDetails, ContractDetail contractDetails, TransactionStatus transactionStatus, double amount) {
        if (receiverAccountDetails == null || senderAccountDetails == null || StringUtils.isBlank((CharSequence)receiverAccountDetails.getAddress()) || StringUtils.isBlank((CharSequence)senderAccountDetails.getAddress())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can't send notification for transaction {} because sender address is '{}' and receiver address is '{}'", new Object[]{senderAccountDetails == null || senderAccountDetails.getAddress() == null ? "null" : senderAccountDetails.getAddress(), receiverAccountDetails == null || receiverAccountDetails.getAddress() == null ? "null" : receiverAccountDetails.getAddress()});
            }
            return;
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(Utils.HASH_PARAMETER, (Object)transactionHash);
        ctx.append(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)senderAccountDetails);
        ctx.append(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)receiverAccountDetails);
        TransactionDetail transactionMessage = this.getEthereumWalletService().getTransactionDetailFromCache(transactionHash);
        ctx.append(Utils.MESSAGE_PARAMETER, (Object)(transactionMessage == null ? "" : transactionMessage.getMessage()));
        if (contractDetails == null) {
            ctx.append(Utils.SYMBOL_PARAMETER, (Object)"ether");
            ctx.append(Utils.CONTRACT_ADDRESS_PARAMETER, (Object)"");
        } else {
            ctx.append(Utils.SYMBOL_PARAMETER, (Object)contractDetails.getSymbol());
            ctx.append(Utils.CONTRACT_ADDRESS_PARAMETER, (Object)contractDetails.getAddress());
        }
        ctx.append(Utils.AMOUNT_PARAMETER, (Object)amount);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)transactionStatus.getNotificationId()))).execute(ctx);
    }

    private TransactionDetail getReceiverAddressFromContractData(GlobalSettings settings, ContractDetail contractDetail, Transaction transaction, TransactionReceipt transactionReceipt) throws InterruptedException, ExecutionException {
        if (transaction == null || transaction.getTo() == null || contractDetail == null) {
            return null;
        }
        String contractAddress = transaction.getTo();
        Set<String> defaultContracts = settings.getDefaultContractsToDisplay();
        if (defaultContracts != null && defaultContracts.contains(contractAddress) && transaction.getInput() != null && !transaction.getInput().equals("0x")) {
            if (transactionReceipt == null) {
                transactionReceipt = this.getTransactionStatus(transaction);
            }
            if (transactionReceipt == null || !transactionReceipt.isStatusOK() || transactionReceipt.getLogs() == null || transactionReceipt.getLogs().isEmpty()) {
                return null;
            }
            try {
                for (int i = 0; i < transactionReceipt.getLogs().size(); ++i) {
                    TransactionDetail contractTransactionDetail = this.getContractTransactiondetail(contractDetail, contractAddress, transactionReceipt, i);
                    if (contractTransactionDetail == null) continue;
                    return contractTransactionDetail;
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)"Error occurred while parsing transaction", e);
            }
        }
        return null;
    }

    private TransactionDetail getContractTransactiondetail(ContractDetail contractDetail, String contractAddress, TransactionReceipt transactionReceipt, int i) {
        EventValues eventValues = ContractUtils.staticExtractEventParameters(Utils.CONTRACT_TRANSFER_EVENT, (org.web3j.protocol.core.methods.response.Log)transactionReceipt.getLogs().get(i));
        if (eventValues != null && eventValues.getIndexedValues() != null && eventValues.getNonIndexedValues() != null && eventValues.getIndexedValues().size() == 2 && eventValues.getNonIndexedValues().size() == 1) {
            String senderAddress = ((Type)eventValues.getIndexedValues().get(0)).getValue().toString();
            String receiverAddress = ((Type)eventValues.getIndexedValues().get(1)).getValue().toString();
            BigInteger amountBigInteger = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            String amountString = BigDecimal.valueOf(Double.parseDouble(amountBigInteger.toString())).divide(BigDecimal.valueOf(10L).pow(contractDetail.getDecimals())).toString();
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setContractAddress(contractAddress);
            transactionDetail.setFrom(senderAddress);
            transactionDetail.setTo(receiverAddress);
            transactionDetail.setContractAmount(Double.parseDouble(amountString));
            transactionDetail.setHash(transactionReceipt.getTransactionHash());
            return transactionDetail;
        }
        return null;
    }

    private TransactionReceipt getTransactionStatus(Transaction transaction) throws InterruptedException, ExecutionException {
        TransactionReceipt transactionReceipt = this.getEthereumClientConnector().getTransactionReceipt(transaction.getHash());
        if (transactionReceipt == null || "0x0".equals(transactionReceipt.getStatus())) {
            return null;
        }
        return transactionReceipt;
    }

    private AccountDetail getAccountDetail(String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return new AccountDetail(null, null, null, address, address, false, true, "/eXoSkin/skin/images/system/UserAvtDefault.png");
        }
        AccountDetail accountDetails = this.getEthereumWalletService().getAccountDetailsByAddress(address);
        if (accountDetails == null) {
            accountDetails = new AccountDetail(null, null, null, address, address, false, true, "/eXoSkin/skin/images/system/UserAvtDefault.png");
        }
        return accountDetails;
    }

    public EthereumWalletService getEthereumWalletService() {
        if (this.ethereumWalletService == null) {
            this.ethereumWalletService = (EthereumWalletService)CommonsUtils.getService(EthereumWalletService.class);
        }
        return this.ethereumWalletService;
    }

    public EthereumClientConnector getEthereumClientConnector() {
        if (this.ethereumClientConnector == null) {
            this.ethereumClientConnector = (EthereumClientConnector)CommonsUtils.getService(EthereumClientConnector.class);
        }
        return this.ethereumClientConnector;
    }
}

