/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.migration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class DeprecatedEthereumWalletService {
    private static final Log LOG = ExoLogger.getLogger(DeprecatedEthereumWalletService.class);
    private static final String SPACE_ACCOUNT_TYPE = "space";
    private static final String USER_ACCOUNT_TYPE = "user";
    private static final String SPACE_WITH_ID_MESSAGE = "Space with id '";
    private static final String IS_NOT_FOUND_MESSAGE = "' is not found";
    private static final String ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE = "address parameter is mandatory";
    private SettingService settingService;
    private IdentityManager identityManager;
    private SpaceService spaceService;

    public Set<Wallet> listSpacesWallets() throws Exception {
        HashSet<Wallet> wallets = new HashSet<Wallet>();
        Set<String> spaces = this.getListOfWalletsOfType(SPACE_ACCOUNT_TYPE);
        for (String spacePrettyName : spaces) {
            Wallet wallet = this.getSpaceDetails(spacePrettyName);
            if (wallet == null) continue;
            wallets.add(wallet);
        }
        return wallets;
    }

    public Set<Wallet> listUserWallets() throws Exception {
        HashSet<Wallet> wallets = new HashSet<Wallet>();
        Set<String> usernames = this.getListOfWalletsOfType(USER_ACCOUNT_TYPE);
        for (String username : usernames) {
            Wallet wallet = this.getUserDetails(username);
            if (wallet == null) continue;
            wallets.add(wallet);
        }
        return wallets;
    }

    public List<TransactionDetail> getAccountTransactions(Long networkId, String address) {
        String addressTransactionsParamName = "WALLET_USER_TRANSACTION" + address + networkId;
        SettingValue addressTransactionsValue = this.getSettingService().get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, addressTransactionsParamName);
        String addressTransactions = addressTransactionsValue == null ? "" : addressTransactionsValue.getValue().toString();
        String[] addressTransactionsArray = addressTransactions.isEmpty() ? new String[]{} : addressTransactions.split(",");
        return Arrays.stream(addressTransactionsArray).map(transaction -> DeprecatedEthereumWalletService.fromStoredValue(transaction)).collect(Collectors.toList());
    }

    public void removeAccountByAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE);
        }
        Wallet accountDetails = this.getWalletByAddress(address.toLowerCase());
        if (accountDetails == null || accountDetails.getAddress() == null) {
            throw new IllegalStateException("Can't find an associated account to address " + address);
        }
        this.getSettingService().remove(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address);
        if (StringUtils.equals((String)accountDetails.getType(), (String)SPACE_ACCOUNT_TYPE)) {
            LOG.info("Deleting wallet address association {} of space {}", new Object[]{address, accountDetails.getId()});
            this.getSettingService().remove(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, accountDetails.getId());
        } else {
            LOG.info("Deleting wallet address association {} of user {}", new Object[]{address, accountDetails.getId()});
            this.getSettingService().remove(Context.USER.id(accountDetails.getId()), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_ADDRESS");
        }
    }

    private Set<String> getListOfWalletsOfType(String walletType) throws Exception {
        if (StringUtils.isBlank((String)walletType) || !USER_ACCOUNT_TYPE.equals(walletType) && !SPACE_ACCOUNT_TYPE.equals(walletType)) {
            throw new IllegalArgumentException("Unrecognized wallet type: " + walletType);
        }
        HashSet<String> names = new HashSet<String>();
        if (USER_ACCOUNT_TYPE.equals(walletType)) {
            int pageSize = 100;
            int current = 0;
            List contexts = null;
            do {
                if ((contexts = this.getSettingService().getContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Utils.WALLET_SCOPE.getName(), Utils.WALLET_SCOPE.getId(), "ADDONS_ETHEREUM_WALLET_ADDRESS", current, pageSize)) != null && !contexts.isEmpty()) {
                    List usernames = contexts.stream().map(context -> context.getId()).collect(Collectors.toList());
                    names.addAll(usernames);
                }
                current += pageSize;
            } while (contexts != null && contexts.size() == pageSize);
        } else {
            int pageSize = 100;
            int current = 0;
            Space[] spaces = null;
            do {
                ListAccess spacesListAccress;
                if ((spaces = (Space[])(spacesListAccress = this.getSpaceService().getAllSpacesWithListAccess()).load(current, pageSize)) != null && spaces.length > 0) {
                    for (Space space : spaces) {
                        String spaceAddress = this.getSpaceAddress(space.getPrettyName());
                        if (!StringUtils.isNotBlank((String)spaceAddress)) continue;
                        names.add(space.getPrettyName());
                    }
                }
                current += pageSize;
            } while (spaces != null && spaces.length == pageSize);
        }
        return names;
    }

    private Wallet getSpaceDetails(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        Space space = Utils.getSpace(id);
        if (space == null) {
            throw new IllegalArgumentException(SPACE_WITH_ID_MESSAGE + id + IS_NOT_FOUND_MESSAGE);
        }
        id = DeprecatedEthereumWalletService.getSpaceId(space);
        return this.getWalletByKey(SPACE_ACCOUNT_TYPE, id);
    }

    private Wallet getUserDetails(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        return this.getWalletByKey(USER_ACCOUNT_TYPE, id);
    }

    private Wallet getWalletByAddress(String address) {
        if (StringUtils.isBlank((String)address)) {
            throw new IllegalArgumentException("wallet addres is mandatory");
        }
        Wallet accountDetail = null;
        SettingValue walletAddressValue = this.getSettingService().get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address);
        if (walletAddressValue != null && walletAddressValue.getValue() != null) {
            String idAndType = walletAddressValue.getValue().toString();
            String id = null;
            if (idAndType.startsWith(USER_ACCOUNT_TYPE)) {
                id = idAndType.replaceFirst(USER_ACCOUNT_TYPE, "");
                accountDetail = this.getUserDetails(id);
            } else if (idAndType.startsWith(SPACE_ACCOUNT_TYPE)) {
                id = idAndType.replaceFirst(SPACE_ACCOUNT_TYPE, "");
                accountDetail = this.getSpaceDetails(id);
            }
            if (accountDetail == null) {
                LOG.info("Can't find the user/space with id {} associated to address {}", new Object[]{id, address});
            } else {
                accountDetail.setAddress(address);
            }
        }
        return accountDetail;
    }

    private Wallet getWalletByKey(String type, String remoteId) {
        if (StringUtils.isBlank((String)type)) {
            throw new IllegalArgumentException("wallet type is mandatory");
        }
        if (StringUtils.isBlank((String)remoteId)) {
            throw new IllegalArgumentException("wallet id is mandatory");
        }
        Wallet accountDetail = null;
        if (USER_ACCOUNT_TYPE.equals(type)) {
            Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
            if (identity == null || identity.getProfile() == null) {
                return null;
            }
            String avatarUrl = identity.getProfile().getAvatarUrl();
            if (StringUtils.isBlank((String)avatarUrl)) {
                avatarUrl = "/rest/v1/social/users/" + remoteId + "/avatar";
            }
            accountDetail = new Wallet();
            accountDetail.setId(remoteId);
            accountDetail.setTechnicalId(Long.parseLong(identity.getId()));
            accountDetail.setType(USER_ACCOUNT_TYPE);
            accountDetail.setName(identity.getProfile().getFullName());
            accountDetail.setAddress(this.getUserAddress(remoteId));
            accountDetail.setPassPhrase(this.getUserPhrase(remoteId));
            accountDetail.setSpaceAdministrator(false);
            accountDetail.setEnabled(identity.isEnable() && !identity.isDeleted());
            accountDetail.setDisabledUser(!identity.isEnable());
            accountDetail.setDeletedUser(identity.isDeleted());
            accountDetail.setAvatar(avatarUrl);
        } else if (SPACE_ACCOUNT_TYPE.equals(type)) {
            Space space = Utils.getSpace(remoteId);
            if (space == null) {
                return null;
            }
            remoteId = DeprecatedEthereumWalletService.getSpaceId(space);
            String prettyName = space.getPrettyName();
            Identity identity = this.getIdentityManager().getOrCreateIdentity(SPACE_ACCOUNT_TYPE, prettyName, true);
            String spaceAddress = this.getSpaceAddress(remoteId);
            accountDetail = new Wallet();
            accountDetail.setId(prettyName);
            accountDetail.setTechnicalId(Long.parseLong(identity.getId()));
            accountDetail.setType(SPACE_ACCOUNT_TYPE);
            accountDetail.setAddress(spaceAddress);
            accountDetail.setPassPhrase(this.getSpacePhrase(remoteId));
            accountDetail.setEnabled(true);
            return accountDetail;
        }
        return accountDetail;
    }

    private String getUserPhrase(String username) {
        SettingValue browserWalletPhraseValue = this.getSettingService().get(Context.USER.id(username), Utils.WALLET_SCOPE, "WALLET_BROWSER_PHRASE");
        if (browserWalletPhraseValue != null && browserWalletPhraseValue.getValue() != null) {
            return browserWalletPhraseValue.getValue().toString();
        }
        return null;
    }

    private String getSpacePhrase(String spaceId) {
        SettingValue browserWalletPhraseValue = this.getSettingService().get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "WALLET_BROWSER_PHRASE" + spaceId);
        if (browserWalletPhraseValue != null && browserWalletPhraseValue.getValue() != null) {
            return browserWalletPhraseValue.getValue().toString();
        }
        return null;
    }

    private String getUserAddress(String id) {
        SettingValue userWalletAddressValue = this.getSettingService().get(Context.USER.id(id), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_ADDRESS");
        if (userWalletAddressValue != null && userWalletAddressValue.getValue() != null) {
            return userWalletAddressValue.getValue().toString().toLowerCase();
        }
        return null;
    }

    private String getSpaceAddress(String id) {
        Space space = Utils.getSpace(id);
        if (space == null) {
            throw new IllegalArgumentException(SPACE_WITH_ID_MESSAGE + id + IS_NOT_FOUND_MESSAGE);
        }
        SettingValue spaceWalletAddressValue = this.getSettingService().get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, space.getPrettyName());
        if (spaceWalletAddressValue == null || spaceWalletAddressValue.getValue() == null) {
            id = DeprecatedEthereumWalletService.getSpaceId(space);
            spaceWalletAddressValue = this.getSettingService().get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, id);
        }
        if (spaceWalletAddressValue != null && spaceWalletAddressValue.getValue() != null) {
            return spaceWalletAddressValue.getValue().toString().toLowerCase();
        }
        return null;
    }

    public static TransactionDetail fromStoredValue(String storedTransactionDetails) {
        TransactionDetail transactionMessage = new TransactionDetail();
        if (StringUtils.isNotBlank((String)storedTransactionDetails)) {
            String[] transactionDetailsArray = storedTransactionDetails.split(";");
            transactionMessage.setHash(transactionDetailsArray[0]);
            transactionMessage.setLabel(transactionDetailsArray.length > 1 ? Utils.decodeString(transactionDetailsArray[1]) : null);
            transactionMessage.setMessage(transactionDetailsArray.length > 2 ? Utils.decodeString(transactionDetailsArray[2]) : null);
        }
        return transactionMessage;
    }

    public static String getSpaceId(Space space) {
        return space.getGroupId().split("/")[2];
    }

    public void removeWallets(Set<Wallet> allWallets) {
    }

    public void removeTransaction(Set<Wallet> allWallets) {
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return this.spaceService;
    }
}

