/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.AddressLabel;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.addon.ethereum.wallet.storage.AccountStorage;
import org.exoplatform.addon.ethereum.wallet.storage.AddressLabelStorage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;

public class EthereumWalletAccountService {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletAccountService.class);
    private AccountStorage accountStorage;
    private AddressLabelStorage labelStorage;
    private ListenerService listenerService;

    public EthereumWalletAccountService(AccountStorage walletAccountStorage, AddressLabelStorage labelStorage) {
        this.accountStorage = walletAccountStorage;
        this.labelStorage = labelStorage;
    }

    public Set<Wallet> listWallets() {
        Set<Wallet> wallets = this.accountStorage.listWallets();
        wallets.forEach(wallet -> wallet.setPassPhrase(null));
        return wallets;
    }

    public long getWalletsCount() {
        return this.accountStorage.getWalletsCount();
    }

    public Wallet getWalletByIdentityId(long identityId) {
        if (identityId == 0L) {
            throw new IllegalArgumentException("identityId is mandatory");
        }
        Identity identity = Utils.getIdentityById(identityId);
        if (identity == null) {
            throw new IllegalArgumentException("Can't find identity with id " + identityId);
        }
        return this.getWalletOfIdentity(identity);
    }

    public Wallet getWalletByTypeAndId(String type, String remoteId, String currentUser) {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet != null) {
            if (WalletType.isSpace(wallet.getType())) {
                wallet.setSpaceAdministrator(Utils.isUserSpaceManager(wallet.getId(), currentUser));
                if (!wallet.isSpaceAdministrator()) {
                    wallet.setPassPhrase(null);
                }
            } else if (!StringUtils.equals((String)wallet.getId(), (String)currentUser)) {
                wallet.setPassPhrase(null);
            }
        }
        return wallet;
    }

    public Wallet getWalletByTypeAndId(String type, String remoteId) {
        Identity identity;
        if (StringUtils.isBlank((String)remoteId)) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        WalletType accountType = WalletType.getType(type);
        if (accountType.isSpace()) {
            remoteId = Utils.getSpacePrettyName(remoteId);
        }
        if ((identity = Utils.getIdentityByTypeAndId(accountType, remoteId)) == null) {
            throw new IllegalArgumentException("Can't find identity with id " + remoteId + " and type " + accountType.getId());
        }
        return this.getWalletOfIdentity(identity);
    }

    public Wallet getWalletByAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet != null) {
            Identity identity = Utils.getIdentityById(wallet.getTechnicalId());
            wallet.setEnabled(wallet.isEnabled() && identity.isEnable() && !identity.isDeleted());
            wallet.setDisabledUser(!identity.isEnable());
            wallet.setDeletedUser(identity.isDeleted());
        }
        return wallet;
    }

    public void saveWallet(Wallet wallet, String currentUser, boolean broadcast) throws Exception {
        if (wallet == null) {
            throw new IllegalArgumentException("Wallet is mandatory");
        }
        if (StringUtils.isBlank((String)wallet.getAddress())) {
            throw new IllegalArgumentException("Wallet address is empty, thus it can't be saved");
        }
        Utils.computeWalletIdentity(wallet);
        Wallet oldWallet = this.accountStorage.getWalletByIdentityId(wallet.getTechnicalId());
        this.checkCanSaveWallet(wallet, oldWallet, currentUser);
        boolean isNew = oldWallet == null;
        wallet.setEnabled(isNew || wallet.isEnabled());
        this.setWalletPassPhrase(wallet, oldWallet);
        this.accountStorage.saveWallet(wallet, isNew);
        if (broadcast) {
            this.getListenerService().broadcast(isNew ? "exo.addon.wallet.addressAssociation.new" : "exo.addon.wallet.addressAssociation.modification", (Object)(oldWallet == null ? null : oldWallet.clone()), (Object)wallet.clone());
        }
    }

    public void removeWalletByAddress(String address, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException("address paramter is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException("Can't find wallet associated to address " + address);
        }
        if (!Utils.isUserAdmin(currentUser)) {
            throw new IllegalAccessException("Current user " + currentUser + " attempts to delete wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        this.accountStorage.removeWallet(wallet.getTechnicalId());
    }

    public void enableWalletByAddress(String address, boolean enable, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException("address paramter is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException("Can't find wallet associated to address " + address);
        }
        if (!Utils.isUserAdmin(currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " attempts to disable wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        wallet.setEnabled(enable);
        this.accountStorage.saveWallet(wallet, false);
    }

    public boolean canAccessWallet(Wallet wallet, String currentUser) {
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType(wallet.getType());
        boolean isUserAdmin = Utils.isUserAdmin(currentUser);
        if (isUserAdmin) {
            return true;
        }
        return type.isUser() && StringUtils.equals((String)currentUser, (String)remoteId) || type.isSpace() && Utils.isUserSpaceMember(wallet.getId(), currentUser);
    }

    public void checkCanSaveWallet(Wallet wallet, Wallet storedWallet, String currentUser) throws IllegalAccessException {
        Wallet walletByAddress;
        if (Utils.isUserAdmin(currentUser)) {
            return;
        }
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType(wallet.getType());
        if (type.isUser()) {
            if (!StringUtils.equals((String)currentUser, (String)remoteId)) {
                throw new IllegalAccessException("User '" + currentUser + "' attempts to modify wallet address of user '" + remoteId + "'");
            }
            if (storedWallet != null && !storedWallet.isEnabled()) {
                LOG.error("User '{}' attempts to modify his wallet while it's disabled", new Object[]{currentUser});
                throw new IllegalAccessException();
            }
        } else {
            Utils.checkUserIsSpaceManager(remoteId, currentUser, true);
        }
        if ((walletByAddress = this.accountStorage.getWalletByAddress(wallet.getAddress())) != null && walletByAddress.getId() != wallet.getId()) {
            throw new IllegalStateException("User " + currentUser + " attempts to assign address of wallet of " + walletByAddress);
        }
    }

    public AddressLabel saveOrDeleteAddressLabel(AddressLabel label, String currentUser) {
        if (label == null) {
            throw new IllegalArgumentException("Label is empty");
        }
        long labelId = label.getId();
        if (labelId > 0L) {
            Identity identity = Utils.getIdentityByTypeAndId(WalletType.USER, currentUser);
            if (identity == null) {
                throw new IllegalStateException("Can't find identity of user " + currentUser);
            }
            AddressLabel storedLabel = this.labelStorage.getLabel(labelId);
            if (storedLabel == null) {
                label.setId(0L);
            } else if (!StringUtils.equals((String)identity.getId(), (String)String.valueOf(storedLabel.getIdentityId()))) {
                LOG.info("{} user modified address {} label from '{}' to '{}'", new Object[]{currentUser, label.getAddress(), storedLabel.getLabel(), label.getLabel()});
            }
        }
        if (StringUtils.isBlank((String)label.getLabel())) {
            if (labelId > 0L) {
                this.labelStorage.removeLabel(label);
            }
        } else {
            label = this.labelStorage.saveLabel(label);
        }
        return label;
    }

    public Set<AddressLabel> getAddressesLabelsVisibleBy(String currentUser) {
        if (!Utils.isUserAdmin(currentUser)) {
            return Collections.emptySet();
        }
        return this.labelStorage.getAllLabels();
    }

    private Wallet getWalletOfIdentity(Identity identity) {
        long identityId = Long.parseLong(identity.getId());
        Wallet wallet = this.accountStorage.getWalletByIdentityId(identityId);
        if (wallet == null) {
            wallet = new Wallet();
            Utils.computeWalletFromIdentity(wallet, identity);
        } else {
            wallet.setEnabled(wallet.isEnabled() && identity.isEnable() && !identity.isDeleted());
        }
        wallet.setDisabledUser(!identity.isEnable());
        wallet.setDeletedUser(identity.isDeleted());
        return wallet;
    }

    private void setWalletPassPhrase(Wallet wallet, Wallet oldWallet) {
        if (StringUtils.isBlank((String)wallet.getPassPhrase())) {
            if (oldWallet == null || StringUtils.isBlank((String)oldWallet.getPassPhrase())) {
                wallet.setPassPhrase(this.generateSecurityPhrase());
            } else {
                wallet.setPassPhrase(oldWallet.getPassPhrase());
            }
        }
    }

    private String generateSecurityPhrase() {
        return RandomStringUtils.random((int)20, (char[])Utils.SIMPLE_CHARS);
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

