/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.rest;

import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardMemberDetail;
import org.exoplatform.addon.ethereum.wallet.reward.service.RewardService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/reward/compute")
@RolesAllowed(value={"rewarding", "administrators"})
public class RewardBudgetREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardBudgetREST.class);
    private RewardService rewardService;

    public RewardBudgetREST(RewardService rewardService) {
        this.rewardService = rewardService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response computeRewards(Set<Long> identityIds, @QueryParam(value="periodDateInSeconds") long periodDateInSeconds) {
        try {
            Set<RewardMemberDetail> rewards = this.rewardService.computeReward(identityIds, periodDateInSeconds);
            return Response.ok(rewards).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting computed reward", (Throwable)e);
            return Response.status((int)500).type("application/json").entity((Object)("{error: " + e.getMessage() + "}")).build();
        }
    }
}

