/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.WalletAccountService;
import org.exoplatform.addon.ethereum.wallet.service.WalletContractService;
import org.exoplatform.addon.ethereum.wallet.service.WalletTransactionService;
import org.exoplatform.addon.ethereum.wallet.storage.TransactionStorage;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONObject;

public class EthereumWalletTransactionService
implements WalletTransactionService {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletTransactionService.class);
    private WalletAccountService accountService;
    private WalletContractService contractService;
    private TransactionStorage transactionStorage;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private long watchedTreatedTransactionsCount;
    private long pendingTransactionMaxDays;

    public EthereumWalletTransactionService(WalletAccountService accountService, TransactionStorage transactionStorage, WalletContractService contractService, InitParams params) {
        this.transactionStorage = transactionStorage;
        this.accountService = accountService;
        this.contractService = contractService;
        if (params != null && params.containsKey((Object)"transaction.pending.maxDays")) {
            String value = params.getValueParam("transaction.pending.maxDays").getValue();
            this.pendingTransactionMaxDays = Long.parseLong(value);
        }
    }

    public List<TransactionDetail> getPendingTransactions(long networkId) {
        return this.transactionStorage.getPendingTransactions(networkId);
    }

    public Set<String> getPendingTransactionHashes(long networkId) {
        List<TransactionDetail> pendingTransactions = this.getPendingTransactions(networkId);
        if (pendingTransactions == null || pendingTransactions.isEmpty()) {
            return Collections.emptySet();
        }
        return pendingTransactions.stream().map(transactionDetail -> transactionDetail.getHash()).collect(Collectors.toSet());
    }

    public List<TransactionDetail> getTransactions(long networkId, String address, String contractAddress, String hash, int limit, boolean onlyPending, boolean administration, String currentUser) throws IllegalAccessException {
        if (this.contractService.isContract(address, networkId)) {
            return this.getContractTransactions(networkId, address, limit, currentUser);
        }
        return this.getWalletTransactions(networkId, address, contractAddress, hash, limit, onlyPending, administration, currentUser);
    }

    public TransactionDetail getTransactionByHash(String hash) {
        return this.transactionStorage.getTransactionByHash(hash);
    }

    public TransactionDetail getAddressLastPendingTransactionSent(long networkId, String address, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.accountService.getWalletByAddress(address);
        if (wallet == null) {
            return null;
        }
        if (!Utils.canAccessWallet((Wallet)wallet, (String)currentUser)) {
            throw new IllegalAccessException("Can't access wallet with address " + address);
        }
        return this.transactionStorage.getAddressLastPendingTransactionSent(networkId, address);
    }

    public void saveTransactionDetail(TransactionDetail transactionDetail, String currentUser, boolean transactionMined) throws IllegalAccessException {
        String senderAddress;
        Wallet senderWallet;
        if (!transactionMined && (senderWallet = this.accountService.getWalletByAddress(senderAddress = StringUtils.isBlank((String)transactionDetail.getBy()) ? transactionDetail.getFrom() : transactionDetail.getBy())) != null) {
            this.accountService.checkCanSaveWallet(senderWallet, senderWallet, currentUser);
        }
        this.transactionStorage.saveTransactionDetail(transactionDetail);
        if (transactionMined) {
            this.broadcastTransactionMinedEvent(transactionDetail);
        }
    }

    public long getWatchedTreatedTransactionsCount() {
        return this.watchedTreatedTransactionsCount;
    }

    public long getPendingTransactionMaxDays() {
        return this.pendingTransactionMaxDays;
    }

    private List<TransactionDetail> getContractTransactions(Long networkId, String contractAddress, int limit, String currentUser) throws IllegalAccessException {
        ContractDetail contractDetail = this.contractService.getContractDetail(contractAddress, networkId);
        if (contractDetail == null) {
            throw new IllegalStateException("Can't find contract with address " + contractAddress);
        }
        if (!Utils.isUserAdmin((String)currentUser) && !Utils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " attempts to access contract transactions with address " + contractAddress);
        }
        List<TransactionDetail> transactionDetails = this.transactionStorage.getContractTransactions(networkId, contractAddress, limit);
        transactionDetails.stream().forEach(transactionDetail -> this.retrieveWalletsDetails((TransactionDetail)transactionDetail, currentUser));
        return transactionDetails;
    }

    private List<TransactionDetail> getWalletTransactions(long networkId, String address, String contractAddress, String hash, int limit, boolean pending, boolean administration, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.accountService.getWalletByAddress(address);
        if (wallet == null) {
            return Collections.emptyList();
        }
        if (!Utils.canAccessWallet((Wallet)wallet, (String)currentUser)) {
            throw new IllegalAccessException("Can't access wallet with address " + address);
        }
        List<TransactionDetail> transactionDetails = this.transactionStorage.getWalletTransactions(networkId, address, contractAddress, hash, limit, pending, administration);
        transactionDetails.stream().forEach(transactionDetail -> this.retrieveWalletsDetails((TransactionDetail)transactionDetail, currentUser));
        return transactionDetails;
    }

    private void retrieveWalletsDetails(TransactionDetail transactionDetail, String currentUser) {
        Wallet senderWallet = this.accountService.getWalletByAddress(transactionDetail.getFrom());
        transactionDetail.setFromWallet(senderWallet);
        Utils.hideWalletOwnerPrivateInformation((Wallet)senderWallet);
        if (StringUtils.isNotBlank((String)transactionDetail.getTo())) {
            Wallet receiverWallet = this.accountService.getWalletByAddress(transactionDetail.getTo());
            Utils.hideWalletOwnerPrivateInformation((Wallet)receiverWallet);
            transactionDetail.setToWallet(receiverWallet);
        }
        if (StringUtils.isNotBlank((String)transactionDetail.getBy())) {
            Wallet senderWalletBy = this.accountService.getWalletByAddress(transactionDetail.getBy());
            Utils.hideWalletOwnerPrivateInformation((Wallet)senderWalletBy);
            transactionDetail.setByWallet(senderWalletBy);
            if (!this.displayTransactionsLabel(senderWalletBy, currentUser)) {
                transactionDetail.setLabel(null);
            }
        } else if (!this.displayTransactionsLabel(senderWallet, currentUser)) {
            transactionDetail.setLabel(null);
        }
    }

    private boolean displayTransactionsLabel(Wallet senderWallet, String currentUserId) {
        if (senderWallet == null) {
            return Utils.isUserAdmin((String)currentUserId);
        }
        String accountId = senderWallet.getId();
        String accountType = senderWallet.getType();
        if (StringUtils.isBlank((String)accountId) || StringUtils.isBlank((String)accountType)) {
            return Utils.isUserAdmin((String)currentUserId);
        }
        if (WalletType.isSpace((String)senderWallet.getType())) {
            if (this.getSpaceService().isSuperManager(currentUserId)) {
                return true;
            }
            Space space = Utils.getSpace((String)accountId);
            return space != null && this.getSpaceService().isManager(space, currentUserId);
        }
        return StringUtils.equalsIgnoreCase((String)accountId, (String)currentUserId);
    }

    private void broadcastTransactionMinedEvent(TransactionDetail transactionDetail) {
        try {
            JSONObject transaction = new JSONObject();
            transaction.put("hash", (Object)transactionDetail.getHash());
            transaction.put("address", (Object)transactionDetail.getFrom());
            transaction.put("status", transactionDetail.isSucceeded());
            this.getListenerService().broadcast("exo.addon.wallet.transaction.mined", null, (Object)transaction);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting transaction mined event: {}", new Object[]{transactionDetail, e});
        }
        ++this.watchedTreatedTransactionsCount;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

