/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardTransaction;
import org.exoplatform.addon.ethereum.wallet.reward.service.RewardTransactionService;
import org.exoplatform.addon.ethereum.wallet.utils.RewardUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.json.JSONObject;

public class WalletRewardTransactionService
implements RewardTransactionService {
    private SettingService settingService;

    public WalletRewardTransactionService(SettingService settingService) {
        this.settingService = settingService;
    }

    public List<JSONObject> getRewardTransactions(Long networkId, String periodType, long startDateInSeconds) {
        String periodTransactionsParamName = this.getPeriodTransactionsParamName(periodType, startDateInSeconds);
        SettingValue periodTransactionsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, periodTransactionsParamName);
        String periodTransactionsString = periodTransactionsValue == null ? "" : periodTransactionsValue.getValue().toString();
        String[] periodTransactionsArray = periodTransactionsString.isEmpty() ? new String[]{} : periodTransactionsString.split(",");
        return Arrays.stream(periodTransactionsArray).map(transaction -> {
            RewardTransaction rewardTransaction = RewardTransaction.fromStoredValue((String)transaction);
            rewardTransaction.setNetworkId(networkId);
            return rewardTransaction.toJSONObject();
        }).collect(Collectors.toList());
    }

    public void saveRewardTransaction(RewardTransaction rewardTransaction) {
        String rewardPeriodTransactionsString;
        if (rewardTransaction == null) {
            throw new IllegalArgumentException("rewardTransaction parameter is mandatory");
        }
        if (rewardTransaction.getNetworkId() == 0L) {
            throw new IllegalArgumentException("transaction NetworkId parameter is mandatory");
        }
        if (StringUtils.isBlank((String)rewardTransaction.getHash())) {
            throw new IllegalArgumentException("transaction hash parameter is mandatory");
        }
        if (StringUtils.isBlank((String)rewardTransaction.getPeriodType())) {
            throw new IllegalArgumentException("transaction PeriodType parameter is mandatory");
        }
        if (rewardTransaction.getStartDateInSeconds() == 0L) {
            throw new IllegalArgumentException("transaction 'period start date' parameter is mandatory");
        }
        if (StringUtils.isBlank((String)rewardTransaction.getReceiverType())) {
            throw new IllegalArgumentException("transaction ReceiverType parameter is mandatory");
        }
        if (StringUtils.isBlank((String)rewardTransaction.getReceiverId())) {
            throw new IllegalArgumentException("transaction ReceiverId parameter is mandatory");
        }
        String rewardPeriodTransactionsParamName = this.getPeriodTransactionsParamName(rewardTransaction.getPeriodType(), rewardTransaction.getStartDateInSeconds());
        SettingValue periodTransactionsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, rewardPeriodTransactionsParamName);
        String string = rewardPeriodTransactionsString = periodTransactionsValue == null ? "" : periodTransactionsValue.getValue().toString();
        if (!rewardPeriodTransactionsString.contains(rewardTransaction.getHash())) {
            String contentToPrepend = rewardTransaction.getToStoreValue();
            rewardPeriodTransactionsString = rewardPeriodTransactionsString.isEmpty() ? contentToPrepend : contentToPrepend + "," + rewardPeriodTransactionsString;
            this.settingService.set(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, rewardPeriodTransactionsParamName, SettingValue.create((String)rewardPeriodTransactionsString));
        }
    }

    private String getPeriodTransactionsParamName(String periodType, long startDateInSeconds) {
        return periodType + startDateInSeconds;
    }
}

